/*
 * Decompiled with CFR 0.152.
 */
package de.xoev.xgenerator.xpathfunctions;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseXML
extends ExtensionFunctionDefinition {
    ThreadLocal<DocumentBuilder> xmlReader = new ThreadLocal();

    public StructuredQName getFunctionQName() {
        return new StructuredQName("xgen", "http://www.xoev.de/de/xgenerator/framework/1/library", "parse-xml");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType((ItemType)NodeKindTest.DOCUMENT, (int)16384);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public boolean hasSideEffects() {
        return false;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                RetentiveErrorHandler errorHandler = new RetentiveErrorHandler();
                try {
                    Builder b;
                    Controller controller = context.getController();
                    if (controller == null) {
                        throw new XPathException("parse-xml() function is not available in this environment");
                    }
                    Configuration config = controller.getConfiguration();
                    StringReader sr = new StringReader(arguments[0].head().getStringValue());
                    InputSource is = new InputSource(sr);
                    SAXSource source = new SAXSource(is);
                    Builder s = b = TreeModel.TINY_TREE.makeBuilder(controller.makePipelineConfiguration());
                    ParseOptions options = new ParseOptions(config.getParseOptions());
                    options.setErrorHandler((ErrorHandler)errorHandler);
                    s.setPipelineConfiguration(b.getPipelineConfiguration());
                    Sender.send((Source)source, (Receiver)s, (ParseOptions)options);
                    TinyDocumentImpl node = (TinyDocumentImpl)b.getCurrentRoot();
                    node.getTreeInfo().setUserData("saxon:document-uri", (Object)"");
                    b.reset();
                    return node;
                }
                catch (XPathException err) {
                    XPathException xe = new XPathException("First argument to parse-xml() is not a well-formed and namespace-well-formed XML document. XML parser reported: " + err.getMessage(), "FODC0006");
                    errorHandler.captureRetainedErrors(xe);
                    xe.maybeSetContext(context);
                    throw xe;
                }
            }
        };
    }

    public static class RetentiveErrorHandler
    implements ErrorHandler {
        public List<SAXParseException> errors = new ArrayList<SAXParseException>();
        public boolean failed = false;

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
            this.failed = true;
        }

        public void captureRetainedErrors(XPathException xe) {
            List<SAXParseException> retainedErrors = this.errors;
            if (!retainedErrors.isEmpty()) {
                ArrayList<ObjectValue> wrappedErrors = new ArrayList<ObjectValue>();
                for (SAXParseException e : retainedErrors) {
                    wrappedErrors.add(new ObjectValue((Object)e));
                }
                xe.setErrorObject((Sequence)SequenceExtent.makeSequenceExtent(wrappedErrors));
            }
        }
    }
}

