<?xml version="1.0" encoding="UTF-8"?>

<!-- Version 1.2.0 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xsl lite gc xoev-cl-2 xoev-cl-4 lite-bib lite-fm">

  <xsl:function name="lite:rule-has-path" as="xs:boolean">
    <xsl:param name="rule" as="element()"/>
    <xsl:sequence select="$lite:rules-and-contexts//lite:rule[@kennung = $rule/@kennung]/not(empty(lite:context/lite:full-paths/lite:path))"/>
  </xsl:function>

  <xsl:function name="lite:navigate" as="element()">
    <xsl:param name="object" as="element()"/>
    <xsl:param name="navigate-elements" as="xs:string*"/>
    <xsl:choose>
      <xsl:when test="empty($navigate-elements)">
        <xsl:sequence select="$object"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="
            lite:navigate($object/child::*[@name =
            (if (not(contains($navigate-elements[1], ':'))) then
              $navigate-elements[1]
            else
              substring-after($navigate-elements[1], ':'))], subsequence($navigate-elements, 2))"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:variable name="lite:rules-and-contexts" as="document-node(element(lite:rules-and-contexts))">
    <xsl:document>
      <lite:rules-and-contexts>
        <xsl:for-each select="$modelle/descendant-or-self::geschaeftsregel">
          <xsl:sort select="@kennung"/>
          <xsl:variable name="rule" select="."/>
          <xsl:variable name="owner" select="parent::*"/>
          <xsl:variable name="fachkontexte" as="element()*">
            <xsl:for-each select="fachkontext">
              <xsl:variable name="fk-string" select="."/>
              <xsl:variable name="fk-baustein" select="lite:resolve(tokenize($fk-string, '/')[1], $rule, false()), lite:resolve(tokenize($fk-string, '/')[1], $rule, true())"/>
              <xsl:sequence select="lite:navigate($fk-baustein, tokenize(substring-after($fk-string, '/'), '/'))"/>
            </xsl:for-each>
          </xsl:variable>
          <xsl:variable name="contexts" select="
              if (not(empty($fachkontexte))) then
                $fachkontexte
              else
                $owner"/>
          <lite:rule kennung="{@kennung}">
            <xsl:apply-templates select="$contexts" mode="lite:rule-context">
              <xsl:with-param name="rule" select="$rule"/>
            </xsl:apply-templates>
          </lite:rule>
        </xsl:for-each>
      </lite:rules-and-contexts>
    </xsl:document>
  </xsl:variable>

  <xsl:template match="element()" mode="lite:rule-context">
    <xsl:param name="rule" as="element()" required="yes"/>
    <xsl:variable name="context" select="."/>
    <xsl:variable name="explicit-auswertungskontext" as="element()*">
      <xsl:for-each select="$rule/auswertungskontext">
        <xsl:variable name="ak-string" select="."/>
        <xsl:variable name="ak-baustein" select="lite:resolve(tokenize($ak-string, '/')[1], $rule, false()), lite:resolve(tokenize($ak-string, '/')[1], $rule, true())"/>
        <xsl:sequence select="lite:navigate($ak-baustein, tokenize(substring-after($ak-string, '/'), '/'))"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="constrained-element" select="($explicit-auswertungskontext, $context)[1]"/>
    <lite:context name="{$context/@name}" constrainedElementName="{$constrained-element/@name}">
      <xsl:variable name="fk-pos" select="position()"/>
      <xsl:variable name="fachkontext-str" select="($rule/fachkontext)[$fk-pos]"/>
      <xsl:variable name="context-in-message-trees" select="$context/(lite:message-nodes-by-object(.))"/>
      <xsl:variable name="constrained-element-in-message-trees" select="$constrained-element/(lite:message-nodes-by-object(.))"/>
      <xsl:variable name="paths-to-context">
        <lite:paths-to-context>
          <xsl:for-each select="$context-in-message-trees">
            <lite:path>
              <xsl:value-of select="lite:path-from-context-to-root(.)"/>
            </lite:path>
          </xsl:for-each>
        </lite:paths-to-context>
      </xsl:variable>
      <xsl:variable name="paths-from-context-to-constrained-element">
        <lite:paths-from-context-to-constrained-element>
          <xsl:choose>
            <xsl:when test="$context[self::datentyp or self::codeDatentyp]">
              <xsl:variable name="context-in-type-trees" select="$lite:type-trees/lite:type-trees/lite:node[@name = concat(lite:prefix($context), ':', $context/@name)]"/>
              <xsl:variable name="constrained-element-in-type-trees" select="$constrained-element/(lite:type-nodes-by-object(.))"/>
              <xsl:for-each select="$constrained-element-in-type-trees">
                <xsl:variable name="path" select="lite:path-from-constrained-element-to-context(., $context-in-type-trees[1])"/>
                <xsl:if test="not(starts-with($path, '#null#') or $path = '')">
                  <lite:path>
                    <xsl:value-of select="$path"/>
                  </lite:path>
                </xsl:if>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
              <xsl:for-each select="$constrained-element-in-message-trees">
                <xsl:variable name="path" select="lite:path-from-constrained-element-to-context(., $context-in-message-trees[1])"/>
                <xsl:if test="not(starts-with($path, '#null#') or $path = '')">
                  <lite:path>
                    <xsl:value-of select="$path"/>
                  </lite:path>
                </xsl:if>
              </xsl:for-each>
            </xsl:otherwise>
          </xsl:choose>
        </lite:paths-from-context-to-constrained-element>
      </xsl:variable>
      <xsl:sequence select="$paths-to-context"/>
      <xsl:sequence select="$paths-from-context-to-constrained-element"/>
      <lite:full-paths>
        <xsl:for-each select="$paths-to-context//lite:path">
          <xsl:variable name="path-to-context" select="."/>
          <xsl:choose>
            <xsl:when test="empty($paths-from-context-to-constrained-element//lite:path)">
              <lite:path>
                <xsl:value-of select="lite:compact-path($path-to-context, $constrained-element, $context)"/>
              </lite:path>
            </xsl:when>
            <xsl:otherwise>
              <xsl:for-each select="$paths-from-context-to-constrained-element//lite:path">
                <lite:path>
                  <xsl:value-of select="lite:compact-path(concat($path-to-context, .), $constrained-element, $context)"/>
                </lite:path>
              </xsl:for-each>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </lite:full-paths>
    </lite:context>
  </xsl:template>

  <xsl:variable name="lite:message-trees" as="document-node(element(lite:message-trees))">
    <xsl:document>
      <lite:message-trees>
        <xsl:for-each select="$xoev-modell/descendant::nachricht[not(@draft = 'true')]">
          <xsl:sort select="@name"/>
          <xsl:variable name="nachricht" select="."/>
          <lite:node name="{concat(lite:prefix(.),':',@name)}">
            <xsl:variable name="node-type" select="
                if (@typ) then
                  lite:resolve(@typ, ., false())
                else
                  ()"/>
            <xsl:variable name="all-types" select="$node-type, $node-type/lite:all-extension-parents(.), lite:all-extension-parents(.)"/>
            <xsl:for-each select="$all-types">
              <xsl:sort select="lite:name-with-name-praefix-and-suffix(.)"/>
              <lite:type name="{lite:name-with-name-praefix-and-suffix(.)}"/>
            </xsl:for-each>
            <xsl:apply-templates select="(., $node-type)/(lite:all-elements(.), lite:all-attributes(.))" mode="lite:tree-node">
              <xsl:sort select="
                  if (@referenz) then
                    lite:name-with-name-praefix-and-suffix(lite:resolve(@referenz, $nachricht, true()))
                  else
                    @name"/>
              <xsl:with-param name="collected-type-names" select="@name"/>
            </xsl:apply-templates>
          </lite:node>
        </xsl:for-each>
      </lite:message-trees>
    </xsl:document>
  </xsl:variable>
  <xsl:key name="lite:message-nodes-by-name" match="lite:node" use="@name"/>
  <xsl:key name="lite:message-nodes-by-type-name" match="lite:node" use="lite:type/@name"/>
  <xsl:function name="lite:message-nodes-by-type-name" as="element(lite:node)*">
    <xsl:param name="name" as="xs:string"/>
    <xsl:sequence select="key('lite:message-nodes-by-type-name', $name, $lite:message-trees)"/>
  </xsl:function>
  <xsl:function name="lite:message-nodes-by-name" as="element(lite:node)*">
    <xsl:param name="name" as="xs:string"/>
    <xsl:sequence select="key('lite:message-nodes-by-name', $name, $lite:message-trees)"/>
  </xsl:function>
  <xsl:function name="lite:message-nodes-by-object" as="element(lite:node)*">
    <xsl:param name="object" as="element()"/>
    <xsl:variable name="element-form" select="
      if (lite:element-form($object) = 'default') then
      lite:element-form-default($object)
      else
      lite:element-form($object)"/>
    <xsl:choose>
      <xsl:when test="$object[self::globaleEigenschaft or self::nachricht]">
        <xsl:sequence select="key('lite:message-nodes-by-name', concat(lite:prefix($object), ':', $object/@name), $lite:message-trees)"/>
      </xsl:when>
      <xsl:when test="$object[self::datentyp or self::codeDatentyp]">
        <xsl:sequence select="key('lite:message-nodes-by-type-name', $object/@name, $lite:message-trees)"/>
      </xsl:when>
      <xsl:when test="$object[self::eigenschaft]">
        <xsl:for-each select="key('lite:message-nodes-by-name', (if ($element-form = 'qualified') then
          concat(lite:prefix($object), ':', $object/@name)
          else
          $object/@name), $lite:message-trees)[lite:lokale-struktur-identisch(., $object)]">
          <xsl:sequence select="."/>
        </xsl:for-each>
      </xsl:when>
    </xsl:choose>
  </xsl:function>

  <xsl:variable name="lite:type-trees" as="document-node(element(lite:type-trees))">
    <xsl:document>
      <lite:type-trees>
        <xsl:for-each select="$xoev-modell/(descendant::datentyp, descendant::codeDatentyp)[not(@draft = 'true')]">
          <xsl:sort select="lite:name-with-name-praefix-and-suffix(.)"/>
          <xsl:variable name="typ" select="."/>
          <lite:node name="{concat(lite:prefix(.),':',@name)}">
            <xsl:apply-templates select="(lite:all-elements(.), lite:all-attributes(.))" mode="lite:tree-node">
              <xsl:sort select="
                  if (@referenz) then
                    lite:name-with-name-praefix-and-suffix(lite:resolve(@referenz, $typ, true()))
                  else
                    @name"/>
              <xsl:with-param name="collected-type-names" select="@name"/>
            </xsl:apply-templates>
          </lite:node>
        </xsl:for-each>
      </lite:type-trees>
    </xsl:document>
  </xsl:variable>
  <xsl:key name="lite:type-nodes-by-name" match="lite:node" use="@name"/>
  <xsl:key name="lite:type-nodes-by-type-name" match="lite:node" use="lite:type/@name"/>
  <xsl:function name="lite:type-nodes-by-type-name" as="element(lite:node)*">
    <xsl:param name="name" as="xs:string"/>
    <xsl:sequence select="key('lite:type-nodes-by-type-name', $name, $lite:type-trees)"/>
  </xsl:function>
  <xsl:function name="lite:type-nodes-by-object" as="element(lite:node)*">
    <xsl:param name="object" as="element()"/>
    <xsl:choose>
      <xsl:when test="$object[self::globaleEigenschaft or self::nachricht]">
        <xsl:sequence select="key('lite:type-nodes-by-name', concat(lite:prefix($object), ':', $object/@name), $lite:type-trees)"/>
      </xsl:when>
      <xsl:when test="$object[self::datentyp or self::codeDatentyp]">
        <xsl:sequence select="key('lite:type-nodes-by-type-name', $object/@name, $lite:type-trees)"/>
        <xsl:sequence select="key('lite:type-nodes-by-name', concat(lite:prefix($object), ':', $object/@name), $lite:type-trees)"/>
      </xsl:when>
      <xsl:when test="$object[self::eigenschaft]">
        <xsl:variable name="element-form" select="
            if (lite:element-form($object) = 'default') then
              lite:element-form-default($object)
            else
              lite:element-form($object)"/>
        <xsl:for-each select="
            key('lite:type-nodes-by-name', (if ($element-form = 'qualified') then
              concat(lite:prefix($object), ':', $object/@name)
            else
              $object/@name), $lite:type-trees)[lite:lokale-struktur-identisch(., $object)]">
          <xsl:sequence select="."/>
        </xsl:for-each>
      </xsl:when>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:lokale-struktur-identisch" as="xs:boolean">
    <xsl:param name="node" as="element(lite:node)"/>
    <xsl:param name="object" as="element()"/>
    <xsl:choose>
      <xsl:when test="$object[self::nachricht or self::globaleEigenschaft]">
        <xsl:sequence select="$object/concat(lite:prefix(.), ':', $object/@name) = $node/@name"/>
      </xsl:when>
      <xsl:when test="$object[self::datentyp]">
        <xsl:sequence select="$object/@name = $node/lite:type/@name or concat(lite:prefix($object), ':', $object/@name) = $node/@name"/>
      </xsl:when>
      <xsl:when test="$object[self::eigenschaft]">
        <xsl:variable name="element-form" select="
            if (lite:element-form($object) = 'default') then
              lite:element-form-default($object)
            else
              lite:element-form($object)"/>
        <xsl:choose>
          <xsl:when test="
              $node/@name = (if ($element-form = 'qualified') then
                concat(lite:prefix($object), ':', $object/@name)
              else
                $object/@name)">
            <xsl:sequence select="lite:lokale-struktur-identisch($node/parent::lite:node, $object/parent::*)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:sequence select="false()"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:function>

  <xsl:template match="eigenschaft" mode="lite:tree-node">
    <xsl:param name="collected-type-names" required="yes"/>
    <xsl:variable name="node" select="."/>
    <xsl:variable name="element-form" select="
        if (lite:element-form(.) = 'default') then
          lite:element-form-default(.)
        else
          lite:element-form(.)"/>
    <xsl:variable name="name">
      <xsl:choose>
        <xsl:when test="@referenz">
          <xsl:value-of select="@referenz"/>
        </xsl:when>
        <xsl:when test="@xsdAttribute">
          <xsl:value-of select="concat('@', @name)"/>
        </xsl:when>
        <xsl:when test="$element-form = 'qualified'">
          <xsl:value-of select="concat(lite:prefix(.), ':', @name)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@name"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <lite:node name="{$name}">
      <xsl:variable name="eigenschaft" select="."/>
      <xsl:variable name="node-type" select="
          if (@typ)
          then
            lite:resolve(@typ, ., false())
          else
            if (@referenz) then
              lite:resolve(@referenz, ., true())/(.,
              if (@typ) then
                lite:resolve(., $eigenschaft, false())
              else
                ())
            else
              ()"/>
      <xsl:for-each select="$node-type/(., lite:all-extension-parents(.))">
        <xsl:sort select="lite:name-with-name-praefix-and-suffix(.)"/>
        <lite:type name="{lite:name-with-name-praefix-and-suffix(.)}"/>
      </xsl:for-each>
      <xsl:if test="not($node-type/@name = $collected-type-names)">
        <xsl:apply-templates select="$node-type/(lite:all-elements(.), lite:all-attributes(.)), lite:all-elements(.), lite:all-attributes(.)" mode="lite:tree-node">
          <xsl:sort select="
              if (@referenz) then
                lite:name-with-name-praefix-and-suffix(lite:resolve(@referenz, $eigenschaft, true()))
              else
                @name"/>
          <xsl:with-param name="collected-type-names" select="$collected-type-names, $node-type/@name"/>
        </xsl:apply-templates>
      </xsl:if>
    </lite:node>
  </xsl:template>

  <xsl:function name="lite:path-from-context-to-root" as="xs:string">
    <xsl:param name="node" as="element()"/>
    <xsl:choose>
      <xsl:when test="$node/parent::lite:message-trees">
        <xsl:value-of select="$node/@name"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(lite:path-from-context-to-root($node/parent::lite:node), '/', $node/@name)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:path-from-constrained-element-to-context" as="xs:string">
    <xsl:param name="node" as="element()"/>
    <xsl:param name="context" as="element()"/>
    <xsl:choose>
      <xsl:when test="empty($node/parent::*)">
        <xsl:text>#null#</xsl:text>
      </xsl:when>
      <xsl:when test="$node/@name = $context/@name">
        <xsl:text/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(lite:path-from-constrained-element-to-context($node/parent::*, $context), '/', $node/@name)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:compact-path" as="xs:string">
    <xsl:param name="full-path" as="xs:string"/>
    <xsl:param name="constrained-element" as="element()"/>
    <xsl:param name="context" as="element()"/>
    <xsl:value-of select="lite:compact-path-step(tokenize($full-path, '/'), 1, $constrained-element, $context)"/>
  </xsl:function>

  <xsl:function name="lite:compact-path-step" as="xs:string">
    <xsl:param name="full-path-tokenized" as="xs:string+"/>
    <xsl:param name="step" as="xs:integer"/>
    <xsl:param name="constrained-element" as="element()"/>
    <xsl:param name="context" as="element()"/>
    <xsl:variable name="step-name" select="$full-path-tokenized[$step]"/>
    <xsl:variable name="last-step-name" select="$full-path-tokenized[last()]"/>
    <xsl:if test="$full-path-tokenized = ('xmeld:datenuebermittlung.aenderungSteuerpflichtiger.0502', 'xmeld:aenderungsteuerpflichtiger', 'xmeld:bzst.bruttomeldedaten', 'xmeld:anschrift')">
    </xsl:if>
    <xsl:variable name="element-form-constrained-element" select="
        if (lite:element-form($constrained-element) = 'default') then
          lite:element-form-default($constrained-element)
        else
          lite:element-form($constrained-element)"/>
    <xsl:variable name="element-form-context" select="
        if (lite:element-form($context) = 'default') then
          lite:element-form-default($context)
        else
          lite:element-form($context)"/>
    <xsl:choose>
      <xsl:when test="empty($full-path-tokenized[$step + 1])">
        <xsl:value-of select="$step-name"/>
      </xsl:when>
      <xsl:when test="
          every $node in lite:message-nodes-by-name($step-name)[string-join(ancestor-or-self::*/@name, '/') = string-join(subsequence($full-path-tokenized, 1, $step), '/')]/descendant::lite:node
            satisfies
            not($last-step-name = $node/@name) or
            ($node/lite:type/@name = $constrained-element/@name or
            $node/@name = (if (($constrained-element/self::eigenschaft and $element-form-constrained-element = 'qualified') or $constrained-element/(self::globaleEigenschaft or self::nachricht)) then
              concat(lite:prefix($constrained-element), ':', $constrained-element/@name)
            else
              $constrained-element/@name)) and
            ($node/ancestor-or-self::lite:node/lite:type/@name = $context/@name or
            $node/ancestor-or-self::lite:node/@name = (if (($context/self::eigenschaft and $element-form-context = 'qualified') or $context/(self::globaleEigenschaft or self::nachricht)) then
              concat(lite:prefix($context), ':', $context/@name)
            else
              $context/@name))">
        <xsl:value-of select="concat($step-name, '//', $last-step-name)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat($step-name, '/', lite:compact-path-step($full-path-tokenized, $step + 1, $constrained-element, $context))"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

</xsl:stylesheet>
