<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook"
   xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
   xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log"
   xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
   xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
   xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
   xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
   xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
   xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
   xmlns="http://docbook.org/ns/docbook"
   xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
   version="2.0"
   exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


   <!-- Einstiegspunkt für die Generierung -->
   <xsl:template match="/" mode="lite:abschnitt-alle-code-datentypen">
      <xsl:apply-templates select="xoev-fachmodell" mode="lite:alle-code-datentypen"/>
   </xsl:template>


   <!-- Erzeuge Datei-->
   <xsl:template match="xoev-fachmodell" mode="lite:alle-code-datentypen">
      <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
      <xsl:variable name="document-directory" select="'dokumente/anhang/codeDatentypen/'"
         as="xs:string"/>
      <xsl:variable name="filename" select="'codeDatentypenAbschnitteGesamt.adoc'"/>

      <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->

      <xsl:variable name="content">
         <xsl:text>[id=code.datentypen.overview]&#x0A;</xsl:text>
         <xsl:text>= Übersicht über die Code-Datentypen&#x0A;&#x0A;</xsl:text>
        
        <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
        <xsl:text>:allecodedatentypen:&#x0A;</xsl:text>
        <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>
        
         <xsl:apply-templates select="." mode="lite:collect-code-datentypen-files"/>
      </xsl:variable>

      <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:if test="//codeDatentyp">
        <xsl:call-template name="xgen:result-document">
          <xsl:with-param name="local-path" select="xs:anyURI(concat($document-directory, $filename))"/>
          <xsl:with-param name="method">text</xsl:with-param>
          <xsl:with-param name="content" select="$content"/>
        </xsl:call-template>
      </xsl:if>

   </xsl:template>

   <!-- Erzeuge den gewünschten Content -->
   <xsl:template match="xoev-fachmodell" mode="lite:collect-code-datentypen-files">
      <xsl:variable name="top-level-paketstruktur" select="concat('../../', //nameTechnisch)"/>

      <xsl:for-each select="//codeDatentyp">
         <xsl:sort select="@name" order="ascending"/>
         <xsl:variable name="paketstruktur-path"
            select="concat(string-join(ancestor::*/@name, '/'), '/', @name, '.adoc')"/>
            <xsl:value-of
              select="concat('include::', $top-level-paketstruktur, '/', $paketstruktur-path,'[]&#x0A;&#x0A;')"/>
      </xsl:for-each>
   </xsl:template>

</xsl:stylesheet>
