<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
    xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log"
    xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
    xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
    xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
    xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
    xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
    xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
    xmlns="http://docbook.org/ns/docbook"
    xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
    version="2.0"
    exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p>Dieses Stylesheet generiert für jeden Codedatentyp einen Abschnitt.</xd:p>
        </xd:desc>
    </xd:doc>


    <xd:doc>
        <xd:desc>
            <xd:p>Einstiegspunkt für die Generierung</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="/" mode="lite:abschnitt-codedatentyp-entry">
        <xsl:apply-templates select="//codeDatentyp[not(@draft = 'true')]"
            mode="lite:abschnitt-codedatentyp"/>
    </xsl:template>

  <!-- TODO Dieses Template scheint nicht mehr verwendet zu werden, die Erzeugung der Dateien für die Codedatentypen findet wohl in lite2adoc.uebersetzungsanweisungen.xsl statt und ruft dort direkt mode="lite:abschnitt-codedatentyp-content" auf -->
    <xd:doc>
        <xd:desc>
            <xd:p>Erzeuge für jeden Codedatentyp eine separate Datei. Diese Dateien werden in einem
                Ordner docbook/dokumente/anhang/codes unter dem Namen des Codedatentyps
                abgelegt.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="codeDatentyp" mode="lite:abschnitt-codedatentyp">
        <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
        <xsl:variable name="document-directory"
            select="'dokumente/codeDatentypen-einzeln-lite2db8/'" as="xs:string"/>
        <xsl:variable name="target-document-directory" select="$document-directory" as="xs:string"/>

        <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
        <xsl:variable name="content">
            <xsl:apply-templates select="." mode="lite:abschnitt-codedatentyp-content"/>
        </xsl:variable>

        <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:call-template name="xgen:result-document">
        <xsl:with-param name="local-path" select="xs:anyURI(concat($target-document-directory, @name, '.adoc'))"/>
        <xsl:with-param name="method">text</xsl:with-param>
        <xsl:with-param name="content" select="$content"/>
      </xsl:call-template>
    </xsl:template>

    <xd:doc>
        <xd:desc>
            <xd:p>Erzeuge den Content für einen Abschnitt zu einem Codedatentyp.</xd:p>
            <xd:p> Der Abschnitt besteht aus folgenden Bestandteilen: <xd:ul>
                    <xd:li>Eine Tabelle mit Informationen zur zugehörigen Codeliste inklusive des
                        Nutzungstyps</xd:li>
                    <xd:li>Eine Tabelle zur Konfiguration des Codedatentyps. Diese Tabelle wurde
                        bisher in der Spezifikation nicht abgebildet. Die Tabellenzeilen werden nur
                        abgebildet, falls der Wert angegeben ist und vom für den Standard
                        angegebenen Defaultwert abweicht.</xd:li>
                    <xd:li>Nutzungs des Datentyps (in separatem Issue noch zu
                        implementieren)</xd:li>
                    <xd:li>Geschäftsregel (in separatem Issue noch zu implementieren)</xd:li>
                </xd:ul>
            </xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="codeDatentyp" mode="lite:abschnitt-codedatentyp-content">
      
      <xsl:apply-templates select="." mode="lite:dokumentation.adoc-header"/>
      
      <xsl:value-of select="concat('[id=',lite:docbook-id(.),']&#x0A;')"/>

        <xsl:value-of select="concat('= ', (@titel, @name)[1], '&#x0A;&#x0A;')"/>

        <xsl:if test="@titel">
            <xsl:value-of select="concat('Typ: `*', @name, '*`&#x0A;&#x0A;')"/>
        </xsl:if>

        <xsl:apply-templates select="beschreibung" mode="lite:dokumentation.FliesstextUndDocBookType"/>

        <xsl:apply-templates select="umsetzungshinweis" mode="lite:dokumentation.FliesstextUndDocBookType"/>

        <xsl:variable name="hatKennung" select="not(empty(@kennung))" as="xs:boolean"/>
        <xsl:variable name="hatVersion" select="not(empty(@version))" as="xs:boolean"/>
        <xsl:variable name="codeliste" select="lite:genutzte-cl-oder-vcl(.)" as="element()?"/>

        <xsl:variable name="codelistentyp">
            <xsl:choose>
                <xsl:when test="$hatKennung and $hatVersion and codesSchemavalidiert = 'true'"
                    >1</xsl:when>
                <xsl:when test="$hatKennung and $hatVersion and codesSchemavalidiert = 'false'"
                    >2</xsl:when>
                <xsl:when test="$hatKennung and $hatVersion = false()">3</xsl:when>
                <xsl:when test="not($hatKennung) and not($hatVersion)">4</xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>

        <!-- Tabelle der Eigenschaften des Codedatentyps -->
        <xsl:text>[cols="14%,86%"]&#x0A;</xsl:text>
        <xsl:text>|===&#x0A;</xsl:text>
        <xsl:text>|Codelisten|&#x0A;&#x0A;</xsl:text>

        <!-- Beschreibungszeile (für Typ 3 unterdrücken) -->
        <xsl:if test="not($codelistentyp = '3')">
            <xsl:text>|-beschreibung|</xsl:text>
            <xsl:choose>
                <xsl:when test="$hatKennung and empty($codeliste)">
                  <xsl:text>#*Fehler: Codeliste nicht gefunden.*#&#x0A;&#x0A; Zum Code-Datentyp </xsl:text><xsl:value-of select="./@name"/>
                    <xsl:text> konnte im Verzeichnis *codelists* keine Codeliste gefunden werden. Möglicherweise fehlt die Codeliste im XRepository.</xsl:text></xsl:when>
                <xsl:when test="not(empty($codeliste))">
                    <xsl:value-of select="(lite:codeliste-beschreibung($codeliste), 'unbestimmt')[1]"/>
                </xsl:when>
                <xsl:otherwise>unbestimmt</xsl:otherwise>
            </xsl:choose>
            <xsl:text>&#x0A;</xsl:text>
        </xsl:if>

        <xsl:text>|-nutzung|</xsl:text>
        <xsl:choose>
            <xsl:when test="$codelistentyp = '1'">
              <xsl:variable name="cl-id" select="replace(concat('tabelle.', @kennung), ':', '.')"/>        
              <xsl:text>Typ: 1, Inhalte der Codeliste siehe &#x0A;</xsl:text>
              <xsl:text>ifdef::volldokument[]&#x0A;</xsl:text>
              <!-- Man befindet sich in der Datei spezifikation.adoc -->
              <xsl:value-of select="concat('xref:#',$cl-id,'[]&#x0A;')"/>
              <xsl:text>endif::[]&#x0A;</xsl:text>
              <xsl:text>ifdef::allecodedatentypen[]&#x0A;</xsl:text>
              <!-- Man befindet sich in der Datei codeDatentypenAbschnitteGesamt.adoc -->
              <xsl:value-of select="concat('xref:../codelisten/codelistenGesamt.adoc#',$cl-id,'[hier]&#x0A;')"/>
              <xsl:text>endif::[]&#x0A;</xsl:text>
              <xsl:text>ifndef::volldokument,allecodedatentypen[]&#x0A;</xsl:text>
              <!-- Man befindet sich in der adoc-Datei eines einzelnen Codedatentyps -->
              <xsl:value-of select="concat('xref:anhang/codelisten/codelistenGesamt.adoc#',$cl-id,'[hier]&#x0A;')"/>
              <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>
             </xsl:when>
          
            <xsl:when test="$codelistentyp = '2'"><xsl:text>Typ: 2, siehe Beschreibung</xsl:text></xsl:when>
          <xsl:when test="$codelistentyp = '3'">
            <!-- Beschreibung soll bei bei Typ 3 nicht mehr angegeben werden, daher nur noch Typ eingetragen. -->
            <xsl:text>Typ: 3</xsl:text>
          </xsl:when>
          
            <xsl:when test="$codelistentyp = '4'">
              <xsl:text>Typ: 4, siehe Beschreibung des Code-Datentyps</xsl:text>
              </xsl:when>
            <xsl:otherwise>
              <xsl:text>#*Fehler bei Ermittlung der Codelistennutzung.*#&#x0A;&#x0A; Die
                Auswertung der Merkmale des Codedatentyps zur Ermittlung des Nutzungstyps führt zu
                einer ungültigen Konstellation.&#x0A;&#x0A;</xsl:text>
              <xsl:value-of select="concat('Hat Kennung? ', $hatKennung)"/>
              <xsl:value-of select="concat(', hat Version? ', $hatVersion)"/>
              <xsl:value-of select="concat(', Codes schemavalidiert? ', @codesSchemavalidiert)"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&#x0A;</xsl:text>

        <xsl:text>|-kennung|</xsl:text>
        <xsl:choose>
            <xsl:when test="$codelistentyp = '3'">
              <!-- Bei Typ 3 ins XRepository verlinken -->
              <xsl:value-of select="concat('https://www.xrepository.de/details/', @kennung, '[*', @kennung, '*] ')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="(@kennung, 'unbestimmt')[1]"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&#x0A;</xsl:text>

        <xsl:text>|-version|</xsl:text>
        <xsl:value-of select="(@version, 'unbestimmt')[1]"/>
        <xsl:text>&#x0A;</xsl:text>

        <xsl:text>|===&#x0A;&#x0A;</xsl:text>
        <!-- Ende der Tabelle der Eigenschaften des Codedatentyps -->

        <!-- Tabelle der Konfiguration des Codedatentyps -->
        <xsl:variable name="konfigurationsinhalt">
            <xsl:if
                test="typDesCodeElements and not(typDesCodeElements = /xoev-fachmodell/konfiguration.xoev-fachmodell/typDesCodeElements)">
                <xsl:text>|Typ des `*code*`-Elements|</xsl:text>
                <xsl:value-of select="typDesCodeElements"/>
                <xsl:text>&#x0A;</xsl:text>
            </xsl:if>
            <xsl:if
                test="nutzungNameElement and not(nutzungNameElement = /xoev-fachmodell/konfiguration.xoev-fachmodell/nutzungNameElement)">
                <xsl:text>|Nutzung des `*name*`-Elements|</xsl:text>
                <xsl:value-of select="nutzungNameElement"/>
                <xsl:text>&#x0A;</xsl:text>
            </xsl:if>
            <xsl:if
                test="benannterCodelistenDatentyp and not(benannterCodelistenDatentyp = /xoev-fachmodell/konfiguration.xoev-fachmodell/benannterCodelistenDatentyp)">
                <xsl:text>|Umsetzung der Codelistenversion als benannter Datentyp|</xsl:text>
                <xsl:value-of select="concat(benannterCodelistenDatentyp, '&#x0A;&#x0A;')"/>
                <xsl:if test="benannterCodelistenDatentypXSD">
                    <xsl:value-of
                        select="concat('(Schema: ', benannterCodelistenDatentypXSD, ')&#x0A;&#x0A;')"
                    />
                </xsl:if>
                <xsl:if test="benannterCodelistenDatentypName">
                    <xsl:value-of
                        select="concat('(Name des Datentyps: ', benannterCodelistenDatentypName, ')&#x0A;&#x0A;')"
                    />
                </xsl:if>
                <xsl:text>&#x0A;</xsl:text>
            </xsl:if>
            <xsl:if test="genutzteCodeSpalte">
                <xsl:text>|zu nutzende Code-Spalte|</xsl:text>
                <xsl:value-of select="genutzteCodeSpalte"/>
                <xsl:text>&#x0A;</xsl:text>
            </xsl:if>
            
            <xsl:if test="genutzteBeschreibungsspalte">
                <xsl:text>|zu nutzende Beschreibungsspalte|</xsl:text>
                <xsl:value-of select="genutzteBeschreibungsspalte"/>
                <xsl:text>&#x0A;</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:if test="not(normalize-space($konfigurationsinhalt) = '')">
            <xsl:text>Konfiguration des Codedatentyps (soweit angegeben und von XÖV-Default-Einstellung abweichend):&#x0A;&#x0A;</xsl:text>
            
            <xsl:text>[cols="39%,61%"]&#x0A;</xsl:text>
            <xsl:text>|===&#x0A;</xsl:text>
            <xsl:text>|Eigenschaft|Wert&#x0A;&#x0A;</xsl:text>
            <xsl:copy-of select="$konfigurationsinhalt"/>
            <xsl:text>|===&#x0A;&#x0A;</xsl:text>
        </xsl:if>
        <!-- Ende der Tabelle der Konfiguration des Codedatentyps -->
    </xsl:template>
</xsl:stylesheet>
