<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" 
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">
	
	
	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>Dieses Stylesheet stellt die Templates für die Erzeugung von vier XÖV lite Bausteinen <xd:i>(Nachrichten, Datentypen, globale Eigenschaften, globale Eigenschaftengruppen)</xd:i> bereit.</xd:p>
			<xd:p>Die Entwicklung des Stylesheets erfolgt im Rahmen des <xd:a href="https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/38">GitLab-Tickets #38</xd:a>.</xd:p>
		</xd:desc>
	</xd:doc>
	
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Erzeuge den Content für einen Baustein. Dabei werden ausschließlich Bausteine berücksichtigt, die sich nicht im Entwurfsstand befinden.</xd:p>
			<xd:p>Aufgrund der strukturellen Ähnlichkeiten ist <xd:b>ein</xd:b> Einstiegstemplate für die Bausteinarten <xd:i>Nachricht</xd:i>, <xd:i>Datentyp</xd:i>, <xd:i>globale Eigenschaftengruppe</xd:i> und <xd:i>globale Eigenschaft</xd:i> ausreichend.</xd:p>
			<xd:p>Für jeden Baustein wird eine DocBook-<xd:i>&lt;section&gt;</xd:i> generiert.</xd:p>
		</xd:desc>
		<xd:param name="svg-width">Breite der SVG-Grafik der Bausteinstruktur</xd:param>
		<xd:param name="svg-height">Höhe der SVG-Grafik der Bausteinstruktur</xd:param>
		<xd:param name="locpath">TODO: prüfen, wird offenbar nicht verwendet</xd:param>
	</xd:doc>
	<xsl:template match="nachricht[not(@draft = 'true')] 
		| datentyp[not(@draft = 'true')] 
		| globaleEigenschaftengruppe[not(@draft = 'true')] 
		| globaleEigenschaft[not(@draft = 'true')]" 
		mode="lite:content-paketstruktur">
	   <xsl:param name="svg-width" as="xs:string?"/>
	   <xsl:param name="svg-height" as="xs:string?"/>
		<xsl:param name="locpath" as="xs:string?"/>
		<section xmlns="http://docbook.org/ns/docbook" xmlns:xlink="http://www.w3.org/1999/xlink" version="5" xml:lang="de" xml:id="{lite:docbook-id(.)}" role="{local-name(.)}">
			<!-- Titel erzeugen -->
			<title>
				<xsl:value-of select="(@titel, @name)[1]"/>
			</title>
			
			<!-- Subtitel (= technischer Name) erzeugen -->
			<subtitle>
				<xsl:choose>
					<xsl:when test="self::nachricht">
						<xsl:text>Nachricht: </xsl:text>
					</xsl:when>
					<xsl:when test="self::datentyp">
						<xsl:text>Typ: </xsl:text>
					</xsl:when>
					<xsl:when test="self::globaleEigenschaftengruppe">
						<xsl:text>Globale Eigenschaftengruppe: </xsl:text>
					</xsl:when>
					<xsl:when test="self::globaleEigenschaft">
						<xsl:text>Globale Eigenschaft: </xsl:text>
					</xsl:when>
				</xsl:choose>
				<emphasis role="codebf">
					<xsl:value-of select="@name"/>
				</emphasis>
				<xsl:if test="self::datentyp">
					<xsl:if test="@abstrakt = 'true'">
						<xsl:text> (abstrakt)</xsl:text>
					</xsl:if>
				</xsl:if>
			</subtitle>
			
			<!-- Bei Nachrichten können Autor- und Leserangaben vorhanden sein. -->
			<xsl:if test="self::nachricht">
				<xsl:apply-templates select="@autor" mode="lite:dokumentation.nachricht.autor-oder-leser"/>
				<xsl:apply-templates select="@leser" mode="lite:dokumentation.nachricht.autor-oder-leser"/>
			</xsl:if>
			
			<!-- Weitere Angaben bei globalen Eigenschaften -->
			<xsl:if test="self::globaleEigenschaft[@typ]">
				<xsl:variable name="artDerEigenschaft" select="if (@xsdAttribute = true()) then 'Attribut' else 'Element'"/>
				<para>
					<xsl:value-of select="concat('Typ des ', $artDerEigenschaft,'s: ',@typ)"/>
					<xsl:if test="not(starts-with(@typ, 'xs:'))">
						<xsl:text> (siehe </xsl:text>
						<xref linkend="{lite:docbook-id(lite:resolve(@typ, ., false()))}" role="AbschnittNummer"/>
						<xsl:text>)</xsl:text>
					</xsl:if>
				</para>
				<xsl:if test="@fixedWert">
					<para>In diesem <xsl:value-of select="$artDerEigenschaft"/> ist nur der Wert "<xsl:value-of select="@fixedWert"/>"
						zulässig (fixed-Wert).</para>
				</xsl:if>
				<xsl:if test="@defaultWert">
					<para>Dieses <xsl:value-of select="$artDerEigenschaft"/> hat den Wert "<xsl:value-of select="@defaultWert"/>",
						sofern kein anderer Wert übermittelt wird (default-Wert).</para>
				</xsl:if>
			</xsl:if>
			
			<!-- Erzeuge die Kerndokumentation für einen Baustein. -->
			<xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>
			<xsl:apply-templates select="umsetzungshinweis" mode="lite:dokumentation.umsetzungshinweis"/>
			
			<!-- Bei Nachrichten können Rechtsgrundlagen vorhanden sein. -->
			<xsl:if test="self::nachricht">
				<xsl:apply-templates select="." mode="lite:dokumentation.nachricht.rechtsgrundlage"/>
			</xsl:if>
						
			<!-- Eine Einbindung (und auch Generierung) eines SVGs erfolgt nur dann, wenn der Baustein SVG-relevanten Content hat. -->
			<xsl:if test="lite:baustein-has-svg-content(.)">				
				<xsl:variable name="scale" select="floor(min((1.1, 750.0 div number($svg-width), 1000.0 div number($svg-height))) * 100)"/>
				
				<xsl:variable name="navigate-up" select="string-join(for $step in ancestor-or-self::* return '../')"/>
				<xsl:variable name="pfadRelativ" select="lite:set-path-or-filename(concat($navigate-up,'zeichnungen/',/xoev-fachmodell/metadaten.standard/nameTechnisch,'/', string-join(ancestor-or-self::*/@name,'/'),'.svg'))"/>
				<xsl:variable name="scale" select="floor(min((1.1, 750.0 div number($svg-width), 1000.0 div number($svg-height))) * 100)"/>

				<figure xml:id="{concat('figure.',lite:docbook-id(.))}">
					<title><xsl:value-of select="@name"/></title>
					<mediaobject>
						<imageobject>
							<imagedata format="svg"
								align="center"
								scale="{$scale}"
								fileref="{$pfadRelativ}"/>
						</imageobject>
					</mediaobject>
				</figure>
			</xsl:if>
			
			<!-- Verarbeite Basistyp-Informationen, sofern vorhanden. -->
			<xsl:apply-templates select="." mode="lite:dokumentation.baustein.basistyp"/>
			
			<!-- Erzeuge Beispielwerte, sofern vorhanden. -->
			<xsl:apply-templates select="." mode="lite:dokumentation.baustein.beispielwert"/>			
			
			<!-- Verarbeite Eigenschaften, sofern vorhanden. -->
			<xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften"/>
			
			<!-- Verarbeite Geschäftsregeln, sofern vorhanden. -->
			<xsl:apply-templates select="." mode="lite:dokumentation.geschaeftsregeln"/>
			
			<!-- Bei Datentypen sind Nutzungs- und Ableitungsinformationen zu erzeugen. -->
		  <xsl:if test="self::datentyp">
		    <xsl:variable name="navigate-up" select="string-join(for $step in ancestor-or-self::* return '../')"/>

		    <xsl:variable name="pfadZurVerwendung" select="lite:set-path-or-filename(concat($navigate-up,'/dokumente/anhang/verwendung/complexTypes/', lite:prefix(.),':',@name,'_list.xml'))"/>
		      		    
		    <xsl:element name="include" namespace="http://www.w3.org/2001/XInclude">
		      <xsl:attribute name="href">
		        <xsl:value-of select="$pfadZurVerwendung"/>
		      </xsl:attribute>
		    </xsl:element>
		    
		  </xsl:if>
		</section>
	</xsl:template>
	
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt Angaben zum Autor bzw. Leser.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="@autor | @leser" mode="lite:dokumentation.nachricht.autor-oder-leser">
		<para role="{if (name() = 'autor') then 'autor' else 'leser'}">
			<emphasis role="strong"><xsl:value-of select="if (name() = 'autor') then 'Autor' else 'Leser'"/>: </emphasis><xsl:value-of select="."/>
		</para>
	</xsl:template>
	
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt einen Eintrag für Rechtsgrundlagen, sofern vorhanden.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht" mode="lite:dokumentation.nachricht.rechtsgrundlage">
		<xsl:if test="rechtsgrundlage">
			<para>
				<emphasis role="strong">Rechtsgrundlagen:</emphasis>
			</para>
			<itemizedlist>
				<xsl:for-each select="rechtsgrundlage">
					<listitem role="rechtsgrundlage">
						<para><xsl:value-of select="."/></para>
					</listitem>
				</xsl:for-each>
			</itemizedlist>
		</xsl:if>
	</xsl:template>
	
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt ergänzende Dokumentation, falls Basistyp-Informationen vorliegen.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft" mode="lite:dokumentation.baustein.basistyp">
		<xsl:if test="@basistyp">
			<xsl:variable name="isRestriction" select="if (@restriction [. = 'true']) then true() else false()"/>
			<xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>
			
			<!-- a) Vererbungsinfo generieren (Einschränkung oder Erweiterung; ggf. Querreferenz im Dokument) -->
			<xsl:variable name="baustein">
				<xsl:choose>
					<xsl:when test="self::nachricht">
						<xsl:text>Diese Nachricht</xsl:text>
					</xsl:when>
					<xsl:when test="self::datentyp">
						<xsl:text>Dieser Datentyp</xsl:text>
					</xsl:when>
					<xsl:when test="self::globaleEigenschaftengruppe">
						<xsl:text>Diese globale Eigenschaftengruppe</xsl:text>
					</xsl:when>
					<xsl:when test="self::globaleEigenschaft">
						<xsl:text>Diese globale Eigenschaft</xsl:text>
					</xsl:when>
					<xsl:otherwise> <!-- sollte derzeit kaum erreichbar sein ;-) -->
						<xsl:text>Dieses globale Element</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<para role="basistyp"> <!-- Art der Vererbung und Basistyp -->
				<xsl:value-of select="$baustein"/>
				<xsl:text> ist eine </xsl:text>
				<xsl:choose>
					<xsl:when test="$isRestriction">
						<xsl:text>Einschränkung</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Erweiterung</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text> des Basistyps </xsl:text>
				<emphasis role="codebf">
					<!--<xsl:choose>
						<xsl:when test="lite:reference-is-from-external-model(@basistyp)">
							<xsl:value-of select="@basistyp"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="substring-after(@basistyp, ':')"/>
						</xsl:otherwise>
					</xsl:choose>-->
					<xsl:value-of select="lite:kuerze-internen-typnamen(@basistyp, $basistyp)"/>
				</emphasis>
				<!-- Link nur erzeugen, wenn kein W3C Simple Type vorliegt -->
				<xsl:if test="not(lite:reference-is-w3c-simpletype(@basistyp))">
					<xsl:text> (siehe </xsl:text>
<!--					<xref linkend="{lite:docbook-id(lite:resolve(@basistyp, ., false()))}" role="AS"/>-->
					<xref linkend="{lite:docbook-id($basistyp)}" role="AS"/>
					<xsl:text>)</xsl:text>
				</xsl:if>
				<xsl:text>.</xsl:text>
			</para>
			
			<!-- b) Pattern, falls vorhanden (andere Behandlung als die anderen W3C-Facetten!) -->
			<xsl:variable name="pattern" as="xs:string*"><![CDATA[<![CDATA[]]><xsl:value-of select="@pattern"/>]]&gt;</xsl:variable>
			<xsl:if test="@pattern[. != '']">
				<para role="pattern">
					<xsl:text>Die Werte müssen dem Muster '</xsl:text>
					<xsl:value-of select="lite:unescaped-xml(string-join($pattern, ''))"/>
					<xsl:text>' entsprechen.</xsl:text>
				</para>
			</xsl:if>
			
			<!-- c) Weitere W3C-Facetten, falls vorhanden -->
			<xsl:variable name="otherFacets" select="(@fractionDigits, @length, @maxExclusive, @maxInclusive, 
																	@maxLength, @minExclusive, @minInclusive, @minLength, 
																	@totalDigits, @whitespace)"/>
			<xsl:if test="$otherFacets">
				<para>
					<xsl:text>Beschränkungen (XML-Schema-Facetten): </xsl:text>
					<xsl:for-each select="$otherFacets">
						<xsl:value-of select="concat(name(), ':', .)"/>
						<xsl:if test="position() != last()">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</para>
			</xsl:if>			
		</xsl:if>
	</xsl:template>
	
	
	<xd:doc scope="component">
		<xd:desc>
			<xd:p>Dieses Template erzeugt einen Eintrag mit einem oder mehreren Beispielwerten, sofern vorhanden.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft" mode="lite:dokumentation.baustein.beispielwert">
		<xsl:if test="beispielwert">
			<para role="beispielwert">
				<xsl:choose>
					<xsl:when test="count(beispielwert) = 1">
						<xsl:text>Beispielwert: </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Beispielwerte: </xsl:text>
					</xsl:otherwise>
				</xsl:choose>					
				<xsl:for-each select="beispielwert">
					<xsl:value-of select="."/>
					<xsl:if test="position() != last()">
						<xsl:text>, </xsl:text>
					</xsl:if>
				</xsl:for-each>
			</para>
		</xsl:if>
	</xsl:template>	
	
</xsl:stylesheet>
