<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">

  <!-- Zur Kontrolle bei Verschachtelungsproblemen: -->
<!--  <xsl:variable name="max-tiefe-nutzung-datentyp" select="10" as="xs:integer"/>-->

  <!--  <xsl:variable name="messages-with-types-var" as="document-node(element(messages-with-types))">-->
  <xsl:variable name="messages-with-types-var" as="document-node()">
    <xsl:document>
      <messages-with-types xmlns="">
        <xsl:for-each select="$xoev-modell/descendant::nachricht[not(@draft = 'true')]">
          <!-- oder generate-id(.)?, dann aber wieder Probleme mit nicht reproduzierbaren IDs beim Testen -->
          <xsl:variable name="kennung" select="lite:docbook-id(.)"/>
          <message xmlns="" id="{$kennung}" name="{@name}">
            <xsl:sequence select="lite:typesUsedInClass(., $kennung)"/>
            <!-- Zur Kontrolle bei Verschachtelungsproblemen: -->
<!--            <xsl:sequence select="lite:typesUsedInClass(., $kennung, 0)"/>-->
          </message>
        </xsl:for-each>
      </messages-with-types>
    </xsl:document>
  </xsl:variable>

  <xsl:key name="messages-with-types-key" match="message" use="type/@id"/>

  <!-- Einstiegspunkt für die Generierung -->
  <xsl:template match="/" mode="lite:nutzung-datentyp">

    <xsl:variable name="document-directory" select="'dokumente/anhang/verwendung/complexTypes'" as="xs:string"/>
    <xsl:variable name="target-document-directory" select="concat($document-directory, '/hilfsstruktur.xml')" as="xs:string"/>
    <xsl:call-template name="lite:write-file-return-log">
      <xsl:with-param name="content" select="$messages-with-types-var"/>
      <xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
    </xsl:call-template>
    <xsl:apply-templates select="descendant::datentyp | descendant::codeDatentyp" mode="lite:nutzung-datentyp"/>

  </xsl:template>

  <xsl:template match="descendant::datentyp[not(@draft = true())] | descendant::codeDatentyp[not(@draft = true())]" mode="lite:nutzung-datentyp">
    <xsl:variable name="kennung" select="lite:docbook-id(.)"/>

    <!-- Variante mit key, funktioniert noch nicht -->
    <!-- <xsl:variable name="funde" select="key('messages-with-types-key', $kennung, $messages-with-types-var)"/> -->
    <xsl:variable name="funde" select="$messages-with-types-var/*:messages-with-types/*:message[*:type/@id = $kennung]"/>

    <xsl:variable name="nachrichtenNumeriert" select="
        every $m in $funde
          satisfies matches(tokenize($m/@name, '\.')[last()], '^[0-9]+$')"/>

    <xsl:variable name="name" select="concat(lite:prefix(.), ':', @name)"/>
    <xsl:variable name="ableitungen" select="$xoev-modell/descendant-or-self::*[@basistyp = $name]"/>

    <xsl:variable name="content">
      <section>
        <title>Nutzung des Datentyps</title>
        <xsl:if test="$funde">
          <para>
            <xsl:text>Dieser Typ kann in den folgenden Nachrichten übermittelt werden: </xsl:text>
            <xsl:for-each select="$funde">
              <xsl:sort select="
                  if ($nachrichtenNumeriert) then
                    tokenize(@name, '\.')[last()]
                  else
                    @name"/>
              <link linkend="{@id}">
                <xsl:value-of select="
                    if ($nachrichtenNumeriert) then
                      tokenize(@name, '\.')[last()]
                    else
                      @name"/>
              </link>
              <xsl:if test="not(position() = last())">
                <xsl:text>, </xsl:text>
              </xsl:if>
            </xsl:for-each>
          </para>
        </xsl:if>

        <xsl:if test="$ableitungen">
          <para>
            <xsl:text>Von diesem Typ leiten ab: </xsl:text>
            <xsl:for-each select="$ableitungen">
              <xsl:sort select="concat(lite:prefix(.), ':', @name)"/>
              <link linkend="{lite:docbook-id(.)}">
                <xsl:value-of select="@name"/>
              </link>
              <xsl:if test="not(position() = last())">
                <xsl:text>, </xsl:text>
              </xsl:if>
            </xsl:for-each>
          </para>
        </xsl:if>

        <xsl:if test="not($funde or $ableitungen)">
          <para>
            <xsl:text>Dieser Typ wird in diesem Modell nicht verwendet.</xsl:text>
          </para>
        </xsl:if>
      </section>
    </xsl:variable>

    <xsl:variable name="document-directory" select="'dokumente/anhang/verwendung/complexTypes'" as="xs:string"/>

    <xsl:variable name="target-document-directory" select="lite:set-path-or-filename(concat($document-directory, '/', lite:prefix(.), ':', @name, '_list.xml'))" as="xs:string"/>

    <xsl:call-template name="lite:write-file-return-log">
      <xsl:with-param name="content" select="$content"/>
      <xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
    </xsl:call-template>

  </xsl:template>


  <xsl:function name="lite:typesUsedInClass" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:param name="collected-ids" as="xs:string*"/>
    <xsl:variable name="datentyp" select="
        if ($baustein/@referenz) then
          lite:resolve($baustein/@referenz, $baustein, true())
        else
          (
          if ($baustein[not(@restriction = 'true')]/@basistyp) then
            lite:resolve($baustein/@basistyp, $baustein, false())
          else
            lite:resolve($baustein/@typ, $baustein, false())
          )"/>
    <xsl:variable name="kennung" select="lite:docbook-id($datentyp)"/>
    <xsl:if test="not(empty($datentyp))">
        <xsl:if test="not(starts-with($kennung, 'xs_')) and not(starts-with($kennung, 'externes.modell.')) and empty(index-of($collected-ids, $kennung))">
        <type xmlns="" id="{$kennung}" name="{$datentyp/@name}"/>
        <xsl:sequence select="lite:typesUsedInClass($datentyp, ($collected-ids, $kennung))"/>
    </xsl:if>
    </xsl:if>
    <xsl:for-each select="$baustein/eigenschaft | $baustein/eigenschaftengruppe">
      <xsl:sequence select="lite:typesUsedInClass(., $collected-ids)"/>
    </xsl:for-each>
  </xsl:function>

</xsl:stylesheet>
