<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">
	
	
	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>**************************************************************************************************************************************</xd:p>
			<xd:p>Dieses Stylesheet stellt allgemein nutzbare Templates bereit.</xd:p>
			<xd:p>**************************************************************************************************************************************</xd:p>
		</xd:desc>
	</xd:doc>	
		
		
		

	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>**************************************************************************************************************************************</xd:p>
			<xd:p>(1) Verarbeitung der <xd:i>beschreibung</xd:i>-Elemente, in denen die Pfleger:in des Standards DocBook-basiert eine bestimmte Struktur (Nachricht, Datentyp, Eigenschaft, etc) dokumentiert hat.</xd:p>
			<xd:p>**************************************************************************************************************************************</xd:p>
		</xd:desc>
	</xd:doc>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template verarbeitet ein <xd:i>beschreibung</xd:i>-Element.</xd:p>
			<xd:p>Dabei wird eine Kopie des Inhalts erzeugt, in der bei allen Kindelementen/-attributen der Namespace-Präfix "<xd:i>db</xd:i>" entfernt wird.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="beschreibung" mode="lite:dokumentation.beschreibung">
		<xsl:choose>
			<!-- Sofern der Beschreibungstext nicht bereits in DocBook formuliert ist, wird er in ein para-Element eingebettet.
				  Dies kann laut KoSIT (2023) an verschiedenen Stellen in den Standards vorkommen und muss berücksichtigt werden. -->
			<xsl:when test="db:*">
				<xsl:apply-templates select="@*|node()"/>
			</xsl:when>
			<xsl:otherwise>
				<para role="beschreibung">
					<xsl:apply-templates select="@*|node()"/>
				</para>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Entferne bei allen Kindelementen den Namespace-Präfix "<xd:i>db</xd:i>".</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="db:*">
		<xsl:element name="{local-name()}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Entferne bei allen Attributen den Namespace-Präfix "<xd:i>db</xd:i>".</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="@db:*">
		<xsl:attribute name="{local-name()}">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Identity Template</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>

	
	
	
	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>**************************************************************************************************************************************</xd:p>
			<xd:p>(2) Templates für weitere Dokumentationsstrukturen (derzeit Geschäftsregeln, Umsetzungshinweise), die unabhängig von ihrer Verortung (siehe match) einheitlich in DocBook abzubilden sind.</xd:p>
			<xd:p>**************************************************************************************************************************************</xd:p>
		</xd:desc>
	</xd:doc>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge eine Tabelle mit Geschäftsregeln.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft | eigenschaft | codeDatentyp | xsdSchema | paket" 
		mode="lite:dokumentation.geschaeftsregeln">
		<!-- Die Tabelle wird nur dann erzeugt, wenn es mindestens eine "geschaeftsregel" gibt. -->
		<xsl:if test="geschaeftsregel">
			<section>
				<title>Geschäftsregeln</title>
				<!--
				<xsl:comment>*** Umgang mit optionalen Kindelementen ('auswertungskontext', 'fachkontext') von Geschäftsregeln: KLÄREN! ***</xsl:comment>
				<xsl:call-template name="annotation.todo.xoevlite.developer">
					<xsl:with-param name="titel">Umgang mit optionalen Kindelementen von Geschäftsregeln: KLÄREN</xsl:with-param>
					<xsl:with-param name="beschreibung">Es ist unklar, wie mit den optionalen Kindelementen ('auswertungskontext', 'fachkontext') von Geschäftsregeln umgegangen werden soll. Dies muss geklärt werden.</xsl:with-param>
					<xsl:with-param name="url">https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/38#datentypen</xsl:with-param>
				</xsl:call-template>
				-->
				<informaltable xml:id="table.{lite:docbook-id(.)}.rules">
					<tgroup cols="2">
						<colspec colname="id" colnum="1" colwidth="20mm"/>
						<colspec colname="regel" colnum="2" colwidth="140mm"/>
						<thead>
							<row>
								<entry>ID</entry>
								<entry>Regel / XPath</entry>
							</row>
						</thead>
						<tbody>
							<xsl:for-each select="geschaeftsregel">
								<xsl:sort select="@kennung"/>
								<row role="geschaeftsregel">
									<entry morerows="1">
										<!-- Liefert die @kennung zurück, aber mit einem "zero width space (ZWSP)" zwischen den einzelnen Buchstaben.
											  Damit wird ein Trennalgorithmus beim Setzen des Dokuments gezielt ausgehebelt.-->
										<xsl:variable name="zwsp" select="'&#x200B;'"/>
										<xsl:value-of select="replace(@kennung, '(.)', concat('$1', $zwsp))"/>
									</entry>
									<entry role="beschreibung">
										<xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>
									</entry>
								</row>
								<row>
									<entry role="spezifikation">
										<para>
											<emphasis role="codebf"><xsl:value-of select="spezifikation"/></emphasis>
										</para>
									</entry>
								</row>
							</xsl:for-each>
						</tbody>
					</tgroup>
				</informaltable>
			</section>
		</xsl:if>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template erzeugt einen Eintrag für Umsetzungshinweise.</xd:p>
			<xd:p>Dabei erfolgt eine Berücksichtigung von "<xd:i>embedded XML</xd:i>", welches bei Umsetzungshinweisen häufig vorkommt.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="umsetzungshinweis" mode="lite:dokumentation.umsetzungshinweis">
		<para>
			<emphasis role="strong">Umsetzungshinweise:</emphasis>
		</para>
		<xsl:choose>
			<xsl:when test="contains(., '&lt;')">
				<xsl:value-of select="lite:unescaped-xml(.)"/>
			</xsl:when>
			<xsl:when test="db:*">
				<xsl:apply-templates select="@*|node()"/>
			</xsl:when>
			<xsl:otherwise>
				<para role="umsetzungshinweis">
					<xsl:value-of select="."/>
				</para>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	


	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>**************************************************************************************************************************************</xd:p>
			<xd:p>(3) Templates für die Erzeugung von ToDo-Anntotationen:</xd:p>
			<xd:p>  - ein Template für Nutzer:innen von XÖV lite Standards</xd:p>
			<xd:p>  - ein Template für Entwickler:innen von XÖV lite</xd:p>
			<xd:p>**************************************************************************************************************************************</xd:p>
		</xd:desc>
	</xd:doc>

	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template erzeugt eine <xd:i>ToDo</xd:i>-Annotation für Pfleger:innen von XÖV lite Standards.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template name="annotation.todo.xoevlite.user">
		<annotation role="todo">
			<info>
				<title>Dokumentation fehlt!</title>
			</info>
			<para>Dieses ToDo wurde automatisch generiert.</para>
		</annotation>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template erzeugt eine <xd:i>ToDo</xd:i>-Annotation für eine XÖV lite Entwickler:in.</xd:p>
		</xd:desc>
		<xd:param name="titel">Text für die Titelzeile des ToDo, die in rot im PDF erscheint</xd:param>
		<xd:param name="beschreibung">Mehr oder weniger umfangreiche Beschreibung des ToDo</xd:param>
		<xd:param name="url">Optionale URL-Angabe (üblicherweise eines GitLab-Tickets, z. B.: "<xd:i><xd:b>https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/16#note_204329</xd:b></xd:i>" – es kann aber auch ein "normaler" Link sein)</xd:param>
	</xd:doc>
	<xsl:template name="annotation.todo.xoevlite.developer">
		<xsl:param name="titel" as="xs:string" required="yes"/>
		<xsl:param name="beschreibung" as="xs:string" required="yes"/>
		<xsl:param name="url" as="xs:string?"/>
		
		<annotation role="todo">
			<info>
				<title>
					<xsl:value-of select="$titel"/>
					<xsl:text>       (*** Entwicklung ***)</xsl:text>
				</title>
			</info>
			<para>
				<xsl:value-of select="$beschreibung"/>
			</para>
			<xsl:if test="$url">
				<para>
					<xsl:text>Siehe auch: </xsl:text>
					<!-- Wir benötigen die letzte Komponente des Pfades ("document entry") um zu erkennen, ob ein GitLab-Ticket vorliegt. -->
					<xsl:variable name="documentEntry" select="tokenize($url,'/')[last()]"/>
					<xsl:choose>	
						<xsl:when test="contains($documentEntry, '#') or $documentEntry castable as xs:integer">
							<!-- GitLab-Ticket: Wir holen uns die Ticketnummer und (falls vorhanden) die Positionsangabe und bauen den Link -->
							<link xlink:href="{$url}">
								<xsl:text>GitLab-Ticket </xsl:text>
								<xsl:value-of select="tokenize($documentEntry,'#')[1]"/>
								<xsl:value-of select="if (tokenize($documentEntry,'#')[2]) then concat(' (', tokenize($documentEntry,'#')[2], ')') else ''"/>
							</link>
						</xsl:when>
						<xsl:otherwise>
							<!-- Kein GitLab-Ticket: Erzeuge "normalen" Link -->
							<link>
								<xsl:value-of select="$url"/>
							</link>
						</xsl:otherwise>
					</xsl:choose>
				</para>
			</xsl:if>
		</annotation>
	</xsl:template>
	
	
</xsl:stylesheet>
