
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:err="http://www.w3.org/2005/xqt-errors" xmlns:awt-font="java:java.awt.Font" version="2.0" exclude-result-prefixes="err xsl lite awt-font">

  <!-- für Icons in der Eigenschaftentabelle eines Bausteins (baustein_eigenschaftentabelle.xsl) -->
  <xsl:param name="icon-directory" required="no" as="xs:anyURI" select="xs:anyURI(concat(substring-before(base-uri(), tokenize(base-uri(), '/')[last()]), '../docbookzubehoer/images/kosit/icons'))"/>

  <!-- Einbindung von Transformationen aus dem "lite" Projekt -->
  <xsl:include href="xgenerator-library.xgen-core.xsl"/>
  <xsl:include href="xgenerator-library.uml-access-layer.xsl"/>
  <xsl:include href="helpers.lite.xsl"/>
  <xsl:include href="lite2xsd.uebersetzungsanweisungen.xsl"/>

  <!-- Einbindung von Transformationen aus lokalem xsl-Verzeichnis-->
  <xsl:include href="helpers.lite-dokumentation.xsl"/>
  <xsl:include href="xsd2svg.uebersetzungsanweisungen.xsl"/>
  <xsl:include href="lite2db.uebersetzungsanweisungen.xsl"/>

  <xsl:output method="xml" indent="yes" use-character-maps="lite:_unescaped-xml-character-map"/>

  <xsl:template match="/">
    <log:logs xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:awt-font="java:java.awt.Font" xmlns:awt-fontrendercontext="java:java.awt.font.FontRenderContext" xmlns:awt-textlayout="java:java.awt.font.TextLayout" xmlns:awt-affinetransform="java:java.awt.geom.AffineTransform" xmlns:awt-rectangle2d="java:java.awt.geom.Rectangle2D">
      <xsl:try>
        <!-- Vermutung Ullrich: 
               An dieser Stelle erfolgt später die Einbindung der SVG-Generierung
               à la <xsl:apply-templates select="." mode="lite:default-xsd2svg"/>
            -->

        <xsl:apply-templates select="." mode="lite:default-lite2db"/>
        <xsl:catch>
          <log:transformation-failure>Ausführungsfehler: <xsl:value-of select="$err:description"/></log:transformation-failure>
        </xsl:catch>
      </xsl:try>
    </log:logs>
  </xsl:template>

</xsl:stylesheet>
