<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="urn:xoev-de:kosit:xoev:classic:transformation_4.2.0" xmlns:xoev-profil="urn:xoev-de:kosit:xoev:classic:access-layer:xoev-profil_4.2.0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:svg="http://www.w3.org/2000/svg" xmlns:xinclude="http://www.w3.org/2001/XInclude" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" version="2.0" exclude-result-prefixes="xsl xmi xgen xoev xoev-profil uml xd log xs svg xinclude">

   <xsl:template match="/" mode="xoev:default">
      <xsl:apply-templates select="$uml:root-model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']/descendant-or-self::packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.))]" mode="xoev:genericode-document"/>
   </xsl:template>

   <xsl:template match="packagedElement" mode="xoev:genericode-document">
      <xsl:variable name="codeliste" select="xoev:dependencies-by-client(.)/uml:resolve-supplier(.)"/>
      <xsl:variable name="add-version" select="count($uml:root-model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']/descendant-or-self::packagedElement[uml:is-Class(.) and xoev-profil:xoevVersionCodeliste(.) and not(xoev-profil:xsdDraft(.)) and xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@xmi:id = $codeliste/@xmi:id]) gt 1"/>
      <xsl:call-template name="xgen:result-document">
         <xsl:with-param name="local-path" select="
               xs:anyURI(concat(replace($codeliste/xoev-profil:xoevCodeliste(.)/@kennung, ':', '-'), if ($add-version) then
                  concat('_', xoev-profil:xoevVersionCodeliste(.)/@version)
               else
                  '', '.xml'))"/>
         <xsl:with-param name="content">
            <xsl:variable name="codelistenversion" select="."/>
            <xsl:variable name="code-spalte" select="(ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'], ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]"/>
            <gc:CodeList>
               <Annotation>
                  <Description>
                     <xsl:for-each select="$codeliste/xoev-profil:xoevCodeliste(.)/nameKurz[. != '']">
                        <xoev-cl-4:shortName>
                           <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut"/>
                        </xoev-cl-4:shortName>
                     </xsl:for-each>
                     <xsl:for-each select="$codeliste/xoev-profil:xoevCodeliste(.)/beschreibung[. != '']">
                        <xoev-cl-4:codelistDescription>
                           <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut">
                              <xsl:with-param name="clean">true</xsl:with-param>
                           </xsl:apply-templates>
                        </xoev-cl-4:codelistDescription>
                     </xsl:for-each>
                     <xsl:for-each select="$codeliste/xoev-profil:xoevCodeliste(.)/herausgebernameKurz[. != '']">
                        <xoev-cl-4:agencyShortName>
                           <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut"/>
                        </xoev-cl-4:agencyShortName>
                     </xsl:for-each>
                     <xsl:for-each select="xoev-profil:xoevVersionCodeliste(.)/beschreibung[. != '']">
                        <xoev-cl-4:versionDescription>
                           <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut">
                              <xsl:with-param name="clean">true</xsl:with-param>
                           </xsl:apply-templates>
                        </xoev-cl-4:versionDescription>
                     </xsl:for-each>
                     <xsl:for-each select="xoev-profil:xoevVersionCodeliste(.)/@datumGueltigkeitAb[. != '']">
                        <xoev-cl-4:validFrom>
                           <xsl:value-of select="."/>
                        </xoev-cl-4:validFrom>
                     </xsl:for-each>
                     <xsl:for-each select="xoev-profil:xoevVersionCodeliste(.)/@versionCodelistenHandbuch[. != '']">
                        <xoev-cl-4:versionHandbook>
                           <xsl:value-of select="."/>
                        </xoev-cl-4:versionHandbook>
                     </xsl:for-each>
                     <xsl:for-each select="xoev-profil:xoevVersionCodeliste(.)/aenderungZurVorversion[. != '']">
                        <xoev-cl-4:changes>
                           <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut"/>
                        </xoev-cl-4:changes>
                     </xsl:for-each>
                  </Description>
               </Annotation>
               <Identification>
                  <ShortName>
                     <xsl:value-of select="$codeliste/xoev-profil:xoevCodeliste(.)/@nameTechnisch"/>
                  </ShortName>
                  <xsl:for-each select="$codeliste/xoev-profil:xoevCodeliste(.)/nameLang">
                     <LongName>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut"/>
                     </LongName>
                  </xsl:for-each>
                  <Version>
                     <xsl:value-of select="xoev-profil:xoevVersionCodeliste(.)/@version"/>
                  </Version>
                  <CanonicalUri>
                     <xsl:value-of select="$codeliste/xoev-profil:xoevCodeliste(.)/@kennung"/>
                  </CanonicalUri>
                  <CanonicalVersionUri>
                     <xsl:value-of select="concat($codeliste/xoev-profil:xoevCodeliste(.)/@kennung, '_', xoev-profil:xoevVersionCodeliste(.)/@version)"/>
                  </CanonicalVersionUri>
                  <xsl:for-each select="xoev-profil:xoevVersionCodeliste(.)/(@bezugsort, bezugsort)">
                     <AlternateFormatLocationUri>
                        <xsl:value-of select="."/>
                     </AlternateFormatLocationUri>
                  </xsl:for-each>
                  <Agency>
                     <xsl:for-each select="$codeliste/xoev-profil:xoevCodeliste(.)/herausgebernameLang">
                        <LongName>
                           <xsl:apply-templates select="." mode="xoev:metadatenwert-mit-attribut"/>
                        </LongName>
                     </xsl:for-each>
                  </Agency>
               </Identification>
               <ColumnSet>
                  <xsl:for-each select="ownedAttribute">
                     <Column Id="{@name}" Use="{(xoev-profil:xoevCodelistenspalte(.)/@verwendung,'required')[1]}">
                        <ShortName>
                           <xsl:value-of select="@name"/>
                        </ShortName>
                        <xsl:for-each select="xoev-profil:xoevCodelistenspalte(.)/@spaltennameLang">
                           <LongName>
                              <xsl:value-of select="."/>
                           </LongName>
                        </xsl:for-each>
                        <Data Type="{(xoev-profil:xoevCodelistenspalte(.)/@datentyp,'string')[1]}">
                           <xsl:for-each select="xoev-profil:xoevCodelistenspalte(.)/@sprache[. != '']">
                              <xsl:attribute name="Lang" select="."/>
                           </xsl:for-each>
                        </Data>
                     </Column>
                  </xsl:for-each>
                  <xsl:for-each select="ownedAttribute[xoev-profil:xoevCodelistenspalte(.)/@codeSpalte = 'true']">
                     <Key Id="{concat(@name,'Key')}">
                        <xsl:if test="xoev-profil:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'">
                           <Annotation>
                              <AppInfo>
                                 <xoev-cl-4:recommendedKeyColumn/>
                              </AppInfo>
                           </Annotation>
                        </xsl:if>
                        <ShortName>
                           <xsl:value-of select="concat(@name, 'Key')"/>
                        </ShortName>
                        <ColumnRef Ref="{@name}"/>
                     </Key>
                  </xsl:for-each>
               </ColumnSet>
               <SimpleCodeList>
                  <xsl:for-each select="$uml:root-model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']/descendant::packagedElement[uml:is-InstanceSpecification(.) and @classifier = current()/@xmi:id and not(xoev-profil:xoevCodelisteneintragDeprecated(.))]">
                     <xsl:sort select="slot[uml:resolve-definingFeature(.)/@xmi:id = $code-spalte/@xmi:id]/value/@value/normalize-space(.)"/>
                     <xsl:variable name="codelisteneintrag" select="."/>
                     <Row>
                        <xsl:for-each select="$code-spalte, $codelistenversion/ownedAttribute[not(@xmi:id = $code-spalte/@xmi:id)]">
                           <Value ColumnRef="{@name}">
                              <xsl:for-each select="$codelisteneintrag/slot[uml:resolve-definingFeature(.)/@xmi:id = current()/@xmi:id]/value/@value/normalize-space(.)">
                                 <SimpleValue>
                                    <xsl:value-of select="."/>
                                 </SimpleValue>
                              </xsl:for-each>
                           </Value>
                        </xsl:for-each>
                     </Row>
                  </xsl:for-each>
               </SimpleCodeList>
            </gc:CodeList>
         </xsl:with-param>
      </xsl:call-template>

   </xsl:template>

   <xsl:template match="element()" mode="xoev:metadatenwert-mit-attribut">
      <xsl:param name="clean" as="xs:boolean" required="no">false</xsl:param>
      <xsl:variable name="text" select="
            if ($clean) then
               xoev:clean-text(.)
            else
               ."/>
      <xsl:choose>
         <xsl:when test="xoev:get-language(.)">
            <xsl:attribute name="xml:lang" select="xoev:get-language(.)"/>
            <xsl:value-of select="substring-after($text, ']')"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$text"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

</xsl:stylesheet>
