/*
 * Decompiled with CFR 0.152.
 */
package de.xoev.xgenerator.xpathfunctions;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class TextWidth
extends ExtensionFunctionDefinition {
    private BufferedImage br = new BufferedImage(500, 500, 5);

    public StructuredQName getFunctionQName() {
        return new StructuredQName("xgen", "http://www.xoev.de/de/xgenerator/framework/1/library", "awt-text-width");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_DOUBLE;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_STRING, SequenceType.SINGLE_INTEGER, SequenceType.SINGLE_INTEGER};
    }

    public boolean hasSideEffects() {
        return false;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                try {
                    Graphics2D gc = TextWidth.this.br.createGraphics();
                    String text = ((StringValue)arguments[0]).getStringValue();
                    String fontName = ((StringValue)arguments[1]).getStringValue();
                    int fontStyle = (int)((IntegerValue)arguments[2]).longValue();
                    int fontSize = (int)((IntegerValue)arguments[3]).longValue();
                    FontRenderContext fontRenderContext = gc.getFontRenderContext();
                    Font font = new Font(fontName, fontStyle, fontSize);
                    TextLayout layout = new TextLayout(text, font, fontRenderContext);
                    return new DoubleValue(layout.getBounds().getWidth());
                }
                catch (Exception e) {
                    throw new XPathException((Throwable)e);
                }
            }
        };
    }
}

