/*
 * Decompiled with CFR 0.152.
 */
package de.xoev.xgenerator.xpathfunctions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XPath2CheckForCompileErrors
extends ExtensionFunctionDefinition {
    private Processor processor = new Processor(false);

    public StructuredQName getFunctionQName() {
        return new StructuredQName("xgen", "http://www.xoev.de/de/xgenerator/framework/1/library", "xpath2-check-for-compile-errors");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_STRING;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.STRING_SEQUENCE};
    }

    public boolean hasSideEffects() {
        return false;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                XPath2CheckForCompileErrors xPath2CheckForCompileErrors = XPath2CheckForCompileErrors.this;
                synchronized (xPath2CheckForCompileErrors) {
                    try {
                        XPathCompiler compiler = XPath2CheckForCompileErrors.this.processor.newXPathCompiler();
                        SequenceIterator it = arguments[1].iterate();
                        Item prefixItem = null;
                        while ((prefixItem = it.next()) != null) {
                            String prefix = prefixItem.getStringValue();
                            Item namespaceItem = it.next();
                            if (namespaceItem == null) {
                                throw new XPathException("Expected an even number of elements in second argument (pairs of prefix/namespace)");
                            }
                            String namespace = namespaceItem.getStringValue();
                            compiler.declareNamespace(prefix, namespace);
                        }
                        compiler.compile(arguments[0].head().getStringValue());
                    }
                    catch (SaxonApiException e) {
                        return new StringValue((CharSequence)e.getLocalizedMessage());
                    }
                    return new SequenceExtent((Item[])new StringValue[0]);
                }
            }
        };
    }
}

