<?xml version="1.0" encoding="UTF-8"?>

<!-- Version 1.2.0 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="2.0" exclude-result-prefixes="xsl lite">

  <xsl:param name="allow-local-retrieval" required="no" as="xs:boolean" select="true()"/>
  <xsl:param name="codelists-directories" required="no" as="xs:anyURI*" select="xs:anyURI(concat(substring-before(base-uri(), tokenize(base-uri(), '/')[last()]), '../codelists'))"/>
  <xsl:param name="codelists-collection" required="no" as="node()*"/>
  <xsl:param name="model-collection" required="no" as="node()*"/>
  <xsl:param name="transformation-name" as="xs:string" required="no"/>
  <xsl:param name="is-schematron-wrapper-context" as="xs:string" required="no" select="'false'"/>

  <xd:doc>
    <xd:desc>Erlaubt den Zugriff auf das eigene Modell.</xd:desc>
  </xd:doc>
  <xsl:variable name="xoev-modell" select="(/xoev-fachmodell, /lite-bib:xoev-bibliothek)"/>

  <xd:doc>
    <xd:desc>intern</xd:desc>
  </xd:doc>
  <xsl:variable name="gc-codelisten" select="
      if (empty($codelists-collection) and $allow-local-retrieval) then
        for $path in $codelists-directories
        return
          collection($path)
      else
        $codelists-collection"/>

  <xd:doc>
    <xd:desc>intern</xd:desc>
  </xd:doc>
  <xsl:variable name="modelle" select="
      if (empty($model-collection) and $allow-local-retrieval) then
        collection(concat(substring-before(base-uri(), tokenize(base-uri(), '/')[last()]), '?select=*.xml;recurse=yes'))
      else
        $model-collection"/>

  <xd:doc scope="component" id="lite:namespace">
    <xd:desc>
      <xd:p>Ermittelt den Namensraum des XSD-Schemas, in dem ein Bestandteil des XÖV-Fachmodells spezifiziert ist.</xd:p>
      <xd:p>Häufige Nutzung in der Form "<xd:i>lite:namespace(.)</xd:i>" um für das gerade behandelte Element den Namensraum zu erhalten.</xd:p>
    </xd:desc>
    <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (<xd:i>xsdSchema</xd:i>, <xd:i>nachricht</xd:i>, <xd:i>datentyp</xd:i>, <xd:i>eigenschaft</xd:i>, usw.).</xd:param>
    <xd:return>Vollständiger Namensraum (<xd:i>targetNamespace</xd:i>) des XSD-Schemas als einfache Zeichenfolge.</xd:return>
  </xd:doc>
  <xsl:function name="lite:namespace" as="xs:string">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        ($element/ancestor-or-self::xsdSchema/@namespace,
        $element/(ancestor-or-self::xoev-fachmodell, ancestor-or-self::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/namespace)[1]"/>
  </xsl:function>

  <xd:doc scope="component" id="lite:prefix">
    <xd:desc>
      <xd:p>Ermittelt das Namensraumspräfix des XSD-Schemas, in dem ein Bestandteil des XÖV-Fachmodells spezifiziert ist. Bei dem Präfix handelt es sich um das Präfix, das dem XSD-Schema originär zugeordnet wurde, nicht unbedingt um das Präfix, über das der Namensraum eines Schemas aus einem anderen Nutzungskontext heraus tatsächlich angesprochen wird. Für letzteren Fall steht die gleichnameige Funktion <xd:i>lite:prefix</xd:i> mit zwei Parametern zur Verfügung.</xd:p>
      <xd:p>Häufige Nutzung in der Form "<xd:i>lite:prefix(.)</xd:i>" um für das gerade behandelte Element das Präfix zu erhalten.</xd:p>
    </xd:desc>
    <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (<xd:i>xsdSchema</xd:i>, <xd:i>nachricht</xd:i>, <xd:i>datentyp</xd:i>, <xd:i>eigenschaft</xd:i>, usw.).</xd:param>
    <xd:return>Präfix des XSD-Schemas als einfache Zeichenfolge.</xd:return>
  </xd:doc>
  <xsl:function name="lite:prefix" as="xs:string?">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        ($element/ancestor-or-self::xsdSchema/@prefix,
        $element/(ancestor-or-self::xoev-fachmodell, ancestor-or-self::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/prefix)[1]"/>
  </xsl:function>

  <xd:doc scope="component" id="lite:prefix2">
    <xd:desc>
      <xd:p>Ermittelt das Namensraumspräfix des XSD-Schemas, in dem ein genutzter Inhalt spezifiziert ist.</xd:p>
      <xd:p>Beispielhafte Nutzung: "<xd:i>lite:prefix(genutzterTyp, nutzendesElement)</xd:i>"</xd:p>
    </xd:desc>
    <xd:param name="element">Der genutzte Inhalt (z. B. <xd:i>datentyp</xd:i> oder <xd:i>globaleEigenschaft</xd:i>), für den das Präfix ermittelt werden soll: <xd:b>Wohin schaue ich?</xd:b></xd:param>
    <xd:param name="from">Ein Bestandteil des XÖV-Fachmodells (z. B. <xd:i>datentyp</xd:i> oder <xd:i>eigenschaft</xd:i>), in dem ein anderer Inhalt (angegeben mit Parameter <xd:i>element</xd:i>), des eigenen oder eines fremden Schemas genutzt wird: <xd:b>Von wo schaue ich?</xd:b></xd:param>
    <xd:return>Präfix des XSD-Schemas, in dem der genutzte Inhalt spezifiziert ist. Das Präfix entspricht <xd:i>lite:prefix($element)</xd:i>, wenn das Präfix nicht im nutzenden Kontext – insb. der Eindeutigkeit halber – manuell bestimmt und damit das originäre Präfix überschrieben wurde.</xd:return>
  </xd:doc>
  <xsl:function name="lite:prefix" as="xs:string">
    <!-- wohin schaue ich: -->
    <xsl:param name="element" as="element()"/>
    <!-- von wo schaue ich: -->
    <xsl:param name="from" as="element()"/>
    <xsl:variable name="nutztSchema" select="$from/ancestor-or-self::*/nutztSchema"/>
    <xsl:variable name="nutztSchema-namespace-version" select="$nutztSchema[@namespace = $element/lite:namespace(.) and (empty(@version) or @version = $element/lite:version(.))]"/>
    <xsl:sequence select="($nutztSchema-namespace-version/@prefix, $element/lite:prefix(.))[1]"/>
  </xsl:function>

  <xd:doc scope="component" id="lite:schema-location">
    <xd:desc>
      <xd:p>Ermittelt die Schema Location des XSD-Schemas, in dem ein Bestandteil des XÖV-Fachmodells spezifiziert ist.</xd:p>
      <xd:p>Häufige Nutzung in der Form "<xd:i>lite:schema-location(.)</xd:i>" um für das gerade behandelte Element die Schema Location zu erhalten.</xd:p>
    </xd:desc>
    <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (<xd:i>xsdSchema</xd:i>, <xd:i>nachricht</xd:i>, <xd:i>datentyp</xd:i>, <xd:i>eigenschaft</xd:i>, usw.).</xd:param>
    <xd:return>Schema Location des XSD-Schemas als einfache Zeichenfolge.</xd:return>
  </xd:doc>
  <xsl:function name="lite:schema-location" as="xs:string">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        ($element/ancestor-or-self::xsdSchema/@schemaLocation,
        concat(($element/(ancestor-or-self::xoev-fachmodell, ancestor-or-self::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/schemaLocationBase, '')[1],
        $element/ancestor-or-self::xsdSchema/@schemaFile))[1]"/>
  </xsl:function>

  <xd:doc scope="component" id="lite:version">
    <xd:desc>
      <xd:p>Ermittelt die Version des XSD-Schemas, in dem ein Bestandteil des XÖV-Fachmodells spezifiziert ist.</xd:p>
      <xd:p>Häufige Nutzung in der Form "<xd:i>lite:version(.)</xd:i>" um für das gerade betrachtete XSD-Schema (Element <xd:i>xsdSchema)</xd:i>) die Version zu erhalten.</xd:p>
    </xd:desc>
    <xd:param name="element">Ein Bestandteil des XÖV-Fachmodells in der Form eines lite-Elements (<xd:i>xsdSchema</xd:i>, <xd:i>nachricht</xd:i>, <xd:i>datentyp</xd:i>, <xd:i>eigenschaft</xd:i>, usw.).</xd:param>
    <xd:return>Version des XSD-Schemas als einfache Zeichenfolge.</xd:return>
  </xd:doc>
  <xsl:function name="lite:version" as="xs:string">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        ($element/ancestor-or-self::xsdSchema/@version,
        $element/(ancestor-or-self::xoev-fachmodell/metadaten.versionStandard, ancestor-or-self::lite-bib:xoev-bibliothek/metadaten.versionBibliothek)/version)[1]"/>
  </xsl:function>

  <xd:doc scope="component" id="lite:element-structures">
    <xd:desc>
      <xd:p>Ermittelt die Elementstrukturen eines Bausteins, d. h. Elemente, Elementgruppen und Any-Elemente.</xd:p>
    </xd:desc>
    <xd:param name="baustein">Ein Baustein des XÖV-Fachmodells in der Form eines lite-Elements (<xd:i>nachricht</xd:i>, <xd:i>datentyp</xd:i>, usw.).</xd:param>
    <xd:return>Elementstrukturen, d. h. <xd:i>eigenschaft</xd:i> ungleich Attribut, <xd:i>eigenschaftengruppe</xd:i> gleich Elementgruppe und <xd:i>anyStruktur</xd:i>.</xd:return>
  </xd:doc>
  <xsl:function name="lite:element-structures" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:sequence select="
        $baustein/*[
        self::eigenschaft and not(@xsdAttribute = 'true') or
        self::eigenschaftengruppe and lite:is-element-group(.) or
        self::anyStruktur]"/>
  </xsl:function>

  <xsl:function name="lite:is-element-group" as="xs:boolean">
    <xsl:param name="gruppe" as="element()"/>
    <xsl:choose>
      <xsl:when test="$gruppe/@referenz">
        <xsl:sequence select="$gruppe/lite:resolve(@referenz, $gruppe, true())/lite:is-element-group(.) = true()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="$gruppe/eigenschaft[not(@xsdAttribute = 'true')] or $gruppe/eigenschaftengruppe/lite:is-element-group(.) = true()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:elements" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="lite:element-structures($baustein)[not(self::anyStruktur)]">
      <xsl:choose>
        <xsl:when test="self::eigenschaftengruppe and not(@referenz)">
          <xsl:sequence select="lite:elements(.)"/>
        </xsl:when>
        <xsl:when test="self::eigenschaftengruppe and @referenz">
          <xsl:sequence select="lite:resolve(@referenz, ., true())/lite:elements(.)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:all-elements" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="$baustein[not(@restriction = 'true')]/@basistyp">
      <xsl:sequence select="lite:resolve(., $baustein, false())/lite:all-elements(.)"/>
    </xsl:for-each>
    <xsl:sequence select="lite:elements($baustein)"/>
  </xsl:function>

  <xsl:function name="lite:all-element-names" as="xs:string*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="lite:all-elements($baustein)">
      <xsl:choose>
        <xsl:when test="@referenz">
          <xsl:sequence select="lite:resolve(@referenz, $baustein, true())/@name"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="@name"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:attribute-structures" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:sequence select="
        $baustein/*[
        self::eigenschaft and @xsdAttribute = 'true' or
        self::eigenschaftengruppe and lite:is-attribute-group(.)]"/>
  </xsl:function>

  <xsl:function name="lite:is-attribute-group" as="xs:boolean">
    <xsl:param name="gruppe" as="element()"/>
    <xsl:sequence select="
        $gruppe/eigenschaft[@xsdAttribute = 'true'] or
        $gruppe/eigenschaftengruppe[not(@referenz)]/lite:is-attribute-group(.) = true() or
        $gruppe/eigenschaftengruppe[@referenz]/lite:resolve(@referenz, $gruppe, true())/lite:is-attribute-group(.) = true()"/>
  </xsl:function>

  <xsl:function name="lite:attributes" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="lite:attribute-structures($baustein)">
      <xsl:choose>
        <xsl:when test="self::eigenschaftengruppe and not(@referenz)">
          <xsl:sequence select="lite:attributes(.)"/>
        </xsl:when>
        <xsl:when test="self::eigenschaftengruppe and @referenz">
          <xsl:sequence select="lite:resolve(@referenz, ., true())/lite:attributes(.)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:all-attributes" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="$baustein[not(@restriction = 'true')]/@basistyp">
      <xsl:sequence select="lite:resolve(., $baustein, false())/lite:all-attributes(.)"/>
    </xsl:for-each>
    <xsl:sequence select="lite:attributes($baustein)"/>
  </xsl:function>

  <xsl:function name="lite:topmost-parent" as="element()?">
    <xsl:param name="object" as="element()"/>
    <xsl:sequence select="lite:all-parents($object)[last()]"/>
  </xsl:function>

  <xsl:function name="lite:all-parents" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="$baustein[@basistyp]/lite:resolve(@basistyp, $baustein, false())">
      <xsl:sequence select="."/>
      <xsl:sequence select="lite:all-parents(.)"/>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:all-restriction-parents" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="$baustein[@basistyp and @restriction = 'true']/lite:resolve(@basistyp, $baustein, false())">
      <xsl:sequence select="."/>
      <xsl:sequence select="lite:all-restriction-parents(.)"/>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:all-extension-parents" as="element()*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="$baustein[@basistyp and not(@restriction = 'true')]/lite:resolve(@basistyp, $baustein, false())">
      <xsl:sequence select="."/>
      <xsl:sequence select="lite:all-extension-parents(.)"/>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:is-simple-type" as="xs:boolean">
    <xsl:param name="type" as="element()"/>
    <!-- empty(X/ancestor::xsdSchema) genau dann wenn es sich bei X um einen W3C-Datentyp handelt -->
    <xsl:sequence select="
        empty($type/ancestor::xsdSchema) or
        $type/union or
        ($type/@basistyp and empty(lite:topmost-parent($type)/ancestor::xsdSchema) and
        not(some $p in ($type, lite:all-parents($type))
          satisfies lite:attributes($p)))"/>
  </xsl:function>

  <xsl:function name="lite:position" as="xs:integer">
    <xsl:param name="baustein" as="element()"/>
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        index-of($baustein/lite:elements(.)/(if (@referenz) then
          lite:resolve(@referenz, ., true())/@name
        else
          @name), $element/(if (@referenz) then
          lite:resolve(@referenz, ., true())/@name
        else
          @name))"/>
  </xsl:function>

  <xsl:function name="lite:get-global-position" as="xs:integer">
    <xsl:param name="baustein" as="element()"/>
    <xsl:param name="element" as="element()"/>
    <xsl:variable name="basistyp" select="$baustein[@basistyp and not(@restriction = 'true')]/lite:resolve(@basistyp, ., false())"/>
    <xsl:choose>
      <xsl:when test="
          $element/(if (@referenz) then
            lite:resolve(@referenz, ., true())/@name
          else
            @name) = $baustein/lite:elements(.)/(if (@referenz) then
            lite:resolve(@referenz, ., true())/@name
          else
            @name)">
        <xsl:value-of select="
            count($baustein/lite:elements(.)[lite:position($baustein, .) le lite:position($baustein, $element)]) +
            count($basistyp/lite:all-elements(.))"/>
      </xsl:when>
      <xsl:when test="$basistyp">
        <xsl:value-of select="lite:get-global-position($basistyp, $element)"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:element-sequence" as="xs:string*">
    <xsl:param name="baustein" as="element()"/>
    <xsl:for-each select="$baustein/lite:all-elements(.)">
      <xsl:value-of select="
          concat(codepoints-to-string(10), 'Position ', position(), ' in Elementsequenz: ', (if (@referenz) then
            lite:resolve(@referenz, ., true())/@name
          else
            @name), if (position() = last()) then
            codepoints-to-string(10)
          else
            '')"/>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:element-form-default" as="xs:string">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        ($element/ancestor-or-self::xsdSchema/@elementFormDefault[. != 'default'],
        $element/(ancestor-or-self::xoev-fachmodell, ancestor-or-self::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/elementFormDefault,
        'qualified')[1]"/>
  </xsl:function>

  <xsl:function name="lite:element-form" as="xs:string">
    <xsl:param name="element" as="element()"/>
    <xsl:sequence select="
        if (($element/@form, 'default')[1] = ('default', lite:element-form-default($element))) then
          'default'
        else
          $element/@form"/>
  </xsl:function>

  <xd:doc scope="component" id="lite:name-with-name-praefix-and-suffix">
    <xd:desc>
      <xd:p>Ermittelt den vollständigen, lokalen Namen (ohne Namensraumpräfix) eines Datentyps oder globalen Elements, gemäß den Angaben zu Namenspräfix und/oder -suffix in der Konfiguration des XÖV-Fachmodells.</xd:p>
      <xd:p>Häufige Nutzung in der Form "<xd:i>lite:name-with-name-praefix-and-suffix(.)</xd:i>" um für das gerade behandelte Element den vollständigen Namen zu erhalten oder in der Form "<xd:i>lite:name-with-name-praefix-and-suffix(lite:resolve(@typ, ., false()))</xd:i>" um den vollständigen Namen eines im Kontextelement referenzierten Typs zu erhalten.</xd:p>
    </xd:desc>
    <xd:param name="element">Ein Baustein des eigenen XÖV-Fachmodells oder eines externen Modells in der Form eines lite-Elements (<xd:i>datentyp</xd:i>, <xd:i>codeDatentyp</xd:i>, <xd:i>globaleEigenschaft</xd:i> usw.).</xd:param>
    <xd:return>Vollständiger, lokaler Name des Bausteins (d. h. ohne Namensraumpräfix). Wenn es sich nicht um einen Datentyp oder globales Element handelt oder für Datentypen keine Namenspräfixe und -suffixe konfiguriert sind, entspricht dieser Name dem Namen im lite-Modell (ohne Namensraumpräfix).</xd:return>
  </xd:doc>
  <xsl:function name="lite:name-with-name-praefix-and-suffix" as="xs:string">
    <xsl:param name="baustein" as="element()"/>
    <!-- Für die Bibliothek ist $konfiguration leer zu setzen. Dort gelten keine globalen Präfixe / Suffixe. -->
    <xsl:variable name="konfiguration" select="$baustein/ancestor-or-self::xoev-fachmodell/konfiguration.xoev-fachmodell"/>
    <xsl:choose>
      <xsl:when test="$baustein[$konfiguration][self::datentyp or self::codeDatentyp]">
        <xsl:value-of select="
            concat(
            ($konfiguration/xsdNamedTypeNamePrefix, '')[1],
            $baustein/@name,
            ($konfiguration/xsdNamedTypeNameSuffix, '')[1])"/>
      </xsl:when>
      <xsl:when test="$baustein[$konfiguration][self::globaleEigenschaft and not(@xsdAttribute = 'true')]">
        <xsl:value-of select="
            concat(
            ($konfiguration/xsdGlobalElementNamePrefix, '')[1],
            $baustein/@name,
            ($konfiguration/xsdGlobalElementNameSuffix, '')[1])"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$baustein/@name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:equal-object" as="xs:boolean">
    <xsl:param name="object-a" as="element()*"/>
    <xsl:param name="object-b" as="element()*"/>
    <!-- empty(X/ancestor::xsdSchema) genau dann wenn es sich bei X um einen W3C-Datentyp handelt -->
    <xsl:sequence select="
        (for $a in $object-a
        return
          for $b in $object-b
          return
            $a/ancestor-or-self::node()/@name = $b/ancestor-or-self::node()/@name and (if (not(empty($a/ancestor::xsdSchema))) then
              $a/lite:namespace(.) = $b/lite:namespace(.) and $a/lite:version(.) = $b/lite:version(.)
            else
              true())) = true()"/>
  </xsl:function>

  <xsl:function name="lite:eigenschaft-lower-bound" as="xs:integer">
    <xsl:param name="eigenschaft" as="element()"/>
    <xsl:sequence select="xs:integer((tokenize($eigenschaft/@multiplizitaet, '\.\.')[1], '1')[1])"/>
  </xsl:function>

  <xsl:function name="lite:eigenschaft-upper-bound" as="xs:string">
    <xsl:param name="eigenschaft" as="element()"/>
    <xsl:sequence select="(tokenize($eigenschaft/@multiplizitaet, '\.\.')[2], '1')[1]"/>
  </xsl:function>


  <xsl:function name="lite:genutzte-cl-oder-vcl" as="element()?">
    <xsl:param name="codeDatentyp" as="element()"/>
    <xsl:sequence select="
        ($gc-codelisten/gc:CodeList
        [*:Identification/*:CanonicalUri = $codeDatentyp/@kennung]
        [not($codeDatentyp/@version) or *:Identification/*:Version = $codeDatentyp/@version])[1]"/>
  </xsl:function>

  <xsl:function name="lite:genutzte-code-spalte" as="xs:string?">
    <xsl:param name="codeDatentyp" as="element()"/>
    <xsl:param name="gc-codeliste" as="element()?"/>
    <xsl:sequence select="
        ($codeDatentyp/genutzteCodeSpalte,
        $gc-codeliste[$codeDatentyp/@version]/*:ColumnSet/*:Key[*:Annotation/*:AppInfo/(*:xoev-code, *:empfohleneCodeSpalte, xoev-cl-4:recommendedKeyColumn)]/*:ColumnRef/@Ref,
        $gc-codeliste[$codeDatentyp/@version]/*:ColumnSet/*:Key[1]/*:ColumnRef/@Ref)[1]"/>
  </xsl:function>

  <xsl:function name="lite:benannter-codelistendatentyp" as="xs:boolean">
    <xsl:param name="codeDatentyp" as="element()"/>
    <xsl:sequence select="($codeDatentyp/benannterCodelistenDatentyp, $xoev-modell/konfiguration.xoev-fachmodell/benannterCodelistenDatentyp, 'true')[1] = 'true'"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-schemavalidiert" as="xs:boolean">
    <xsl:param name="codeDatentyp" as="element()"/>
    <xsl:sequence select="$codeDatentyp/@kennung and $codeDatentyp/@version and ($codeDatentyp/codesSchemavalidiert, $xoev-modell/konfiguration.xoev-fachmodell/codesSchemavalidiert, 'true')[1] = 'true'"/>
  </xsl:function>

  <xsl:function name="lite:codelist-simple-type-name" as="xs:string">
    <xsl:param name="code-type" as="element()"/>
    <xsl:variable name="gc-codeliste" select="lite:genutzte-cl-oder-vcl($code-type)"/>
    <xsl:sequence select="($code-type/benannterCodelistenDatentypName, $gc-codeliste/*:Identification/*:ShortName)[1]"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-nameLang" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Identification/*:LongName"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-nameKurz" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(*:nameKurz, xoev-cl-4:shortName)"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-nameTechnisch" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Identification/*:ShortName"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-kennung" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Identification/*:CanonicalUri"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-beschreibung" as="xs:string*">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(xoev-cl-4:codelistDescription, *:beschreibung-codeliste, *:beschreibung)[1]/lite:clean-text(.)"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-herausgebernameLang" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Identification/*:Agency/*:LongName"/>
  </xsl:function>

  <xsl:function name="lite:codeliste-herausgebernameKurz" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(*:herausgebernameKurz, xoev-cl-4:agencyShortName)"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-version" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Identification/*:Version"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-beschreibung" as="xs:string*">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(*:beschreibung-versionCodeliste, xoev-cl-4:versionDescription)/lite:clean-text(.)"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-bezugsort" as="xs:string*">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Identification/*:AlternateFormatLocationUri"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-datumGueltigkeitAb" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(xoev-cl-4:validFrom, *:datumGueltigkeitAb, *:datumgueltigkeitab)[1]"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-versionCodelistenHandbuch" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(*:versionCodelistenHandbuch, xoev-cl-4:versionHandbook)"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-versionXOEVHandbuch" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/xoev-cl-2:versionXOEVHandbuch"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-aenderungZurVorversion" as="xs:string?">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:Annotation/*:Description/(*:aenderungZurVorversion, xoev-cl-4:changes)"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalten" as="element()*">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:ColumnSet/*:Column"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-spaltennameTechnisch" as="xs:string?">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="$genericode-cl-spalte/*:ShortName"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-spaltennameLang" as="xs:string?">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="$genericode-cl-spalte/*:LongName"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-datentyp" as="xs:string?">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="$genericode-cl-spalte/*:Data/@Type"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-sprache" as="xs:string?">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="$genericode-cl-spalte/*:Data/@Lang"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-codeSpalte" as="xs:boolean">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="$genericode-cl-spalte/../*:Key/*:ColumnRef/@Ref = $genericode-cl-spalte/@Id"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-verwendung" as="xs:string?">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="$genericode-cl-spalte/@Use"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-spalte-empfohleneCodeSpalte" as="xs:boolean">
    <xsl:param name="genericode-cl-spalte" as="element()"/>
    <xsl:sequence select="
        not(empty(
        $genericode-cl-spalte/../*:Key[*:ColumnRef/@Ref = $genericode-cl-spalte/@Id and *:Annotation/*:AppInfo/(*:xoev-code, *:empfohleneCodeSpalte, xoev-cl-4:recommendedKeyColumn)]))"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-zeilen" as="element()*">
    <xsl:param name="genericode-cl" as="element()"/>
    <xsl:sequence select="$genericode-cl/*:SimpleCodeList/*:Row"/>
  </xsl:function>

  <xsl:function name="lite:versioncodeliste-zeile-spaltenwert" as="element()?">
    <xsl:param name="genericode-cl-zeile" as="element()"/>
    <xsl:param name="spalten-id" as="xs:string"/>
    <xsl:sequence select="$genericode-cl-zeile/*:Value[@ColumnRef = $spalten-id]/*:SimpleValue"/>
  </xsl:function>

  <!-- intern -->
  <!-- Rückgabe mehrerer Elemente wird über Schematron-Prüfanweisung abgefangen. Andernfalls erhalten Nutzende nur eine technische Fehlermeldung.  -->
  <xsl:function name="lite:_get-obj" as="element()*">
    <xsl:param name="name" as="xs:string?"/>
    <xsl:param name="schemas" as="element()*"/>
    <xsl:param name="is-ref" as="xs:boolean"/>
    <xsl:choose>
      <xsl:when test="$is-ref">
        <xsl:sequence select="$schemas/(descendant::globaleEigenschaft, descendant::globaleEigenschaftengruppe, descendant::nachricht)[@name = $name]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="$schemas/(descendant::datentyp, descendant::codeDatentyp)[@name = $name]"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xd:doc scope="component">
    <xd:desc>
      <xd:p>Ermittelt einen genutzten Inhalt anhand seines qualifizierten Namens.</xd:p>
      <xd:p>Beispielhafte Nutzung: "<xd:i>lite:resolve(@typ, ., false())</xd:i>" zur Ermittlung eines in einer Eigenschaft (".") genutzten Typs</xd:p>
    </xd:desc>
    <xd:param name="qualified-name">Der qualifizierte Name (z. B. "xdomea:KontaktType", "din91379:datatypeC" oder "xs:boolean") des genutzten Inhalts (z. B. <xd:i>datentyp</xd:i> oder <xd:i>globaleEigenschaft</xd:i>), der ermittelt werden soll.</xd:param>
    <xd:param name="from">Der den Inhalt nutzende Kontext (z. B. <xd:i>eigenschaft</xd:i>): <xd:i>Von wo schaue ich?</xd:i></xd:param>
    <xd:param name="is-ref">Bestimmt, ob es sich beim gesuchten Inhalt um einen Typ handelt (false) oder eine globaleEigenschaft (true).</xd:param>
    <xd:return>Der genutzte Inhalt als Element des eigenen lite Fachmodells, eines fremden lite Fachmodells oder der lite XÖV-Bibliothek. Die Rückgabe mehrerer Elemente wird über eine Schematron-Prüfanweisung abgefangen. Andernfalls erhielten Nutzende nur eine technische Fehlermeldung.</xd:return>
  </xd:doc>
  <xsl:function name="lite:resolve" as="element()*">
    <xsl:param name="qualified-name" as="xs:string?"/>
    <!-- von wo schaue ich: -->
    <xsl:param name="from" as="element()"/>
    <!-- handelt es sich um eine Referenz (= true) oder einen Typ (= false): -->
    <xsl:param name="is-ref" as="xs:boolean"/>
    <xsl:variable name="prefix" select="tokenize($qualified-name, ':')[1]"/>
    <xsl:variable name="name" select="tokenize($qualified-name, ':')[2]"/>
    <xsl:variable name="nutztSchema" select="$from/ancestor-or-self::*/nutztSchema" as="element(nutztSchema)*"/>
    <xsl:variable name="nutztSchema-prefix" select="$nutztSchema[@prefix = $prefix]" as="element(nutztSchema)?"/>
    <xsl:choose>
      <xsl:when test="starts-with($qualified-name, 'xs:')">
        <xsl:variable name="dt" as="element()">
          <lite-fm:datentyp name="{substring-after($qualified-name,':')}"/>
        </xsl:variable>
        <xsl:sequence select="$dt"/>
      </xsl:when>
      <xsl:when test="$nutztSchema-prefix">
        <xsl:variable name="schemas" select="
            $modelle/descendant::xsdSchema[not(@draft = 'true')]
            [lite:namespace(.) = $nutztSchema-prefix/@namespace]
            [empty($nutztSchema-prefix/@version) or lite:version(.) = $nutztSchema-prefix/@version]" as="element(xsdSchema)*"/>
        <xsl:sequence select="lite:_get-obj($name, $schemas, $is-ref)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="schemas-zu-prefix" select="$modelle/descendant::xsdSchema[not(@draft = 'true')][lite:prefix(.) = $prefix]" as="element(xsdSchema)*"/>
        <xsl:choose>
          <xsl:when test="count(distinct-values($schemas-zu-prefix/concat(lite:namespace(.), lite:version(.)))) = 1">
            <xsl:sequence select="lite:_get-obj($name, $schemas-zu-prefix, $is-ref)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="schemas" select="
                $schemas-zu-prefix[
                some $n in $nutztSchema
                  satisfies
                  $n/@namespace = lite:namespace(.) and
                  (empty($n/@version) or $n/@version = lite:version(.))]" as="element(xsdSchema)*"/>
            <xsl:sequence select="lite:_get-obj($name, $schemas, $is-ref)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="lite:resolve-schema-by-id" as="element(xsdSchema)">
    <xsl:param name="schema-id" as="xs:string"/>
    <xsl:sequence select="$modelle/descendant::xsdSchema[not(@draft = 'true')][lite:schema-id(.) = $schema-id]"/>
  </xsl:function>



  <xsl:function name="lite:used-schemas" as="element()*">
    <xsl:param name="schema" as="element(xsdSchema)"/>
    <xsl:variable name="used-types" select="
        distinct-values(
        ($schema/(descendant::nachricht, descendant::eigenschaft, descendant::globaleEigenschaft)/@typ,
        $schema/(descendant::datentyp, descendant::eigenschaft, descendant::nachricht, descendant::globaleEigenschaft)/@basistyp))"/>
    <xsl:variable name="referenced-objects" select="distinct-values($schema/(descendant::eigenschaft, descendant::eigenschaftengruppe)/@referenz)"/>
    <xsl:variable name="used-schemas" as="element()*">
      <xsl:for-each select="$used-types">
        <xsl:sequence select="lite:resolve(., $schema, false())/ancestor::xsdSchema"/>
      </xsl:for-each>
      <xsl:for-each select="$referenced-objects">
        <xsl:sequence select="lite:resolve(., $schema, true())/ancestor::xsdSchema"/>
      </xsl:for-each>
      <xsl:if test="$schema/descendant::codeDatentyp">
        <xsl:sequence select="$modelle/descendant::xsdSchema[lite:namespace(.) = 'http://xoev.de/schemata/code/1_0']"/>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="used-distinct-schemas" as="element()*">
      <xsl:for-each select="$used-schemas[lite:schema-id(.) != $schema/lite:schema-id(.)]">
        <xsl:variable name="us" select="."/>
        <xsl:variable name="pos" select="position()"/>
        <xsl:if test="
            every $s in $used-schemas[position() lt $pos]
              satisfies
              lite:schema-id($s) != lite:schema-id($us)">
          <xsl:sequence select="."/>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:sequence select="$used-distinct-schemas"/>
  </xsl:function>

  <xsl:function name="lite:all-included-schemas" as="element(xsdSchema)*">
    <xsl:param name="schema" as="element(xsdSchema)"/>
    <xsl:for-each select="lite:directly-included-schemas($schema)">
      <xsl:sequence select="."/>
      <xsl:sequence select="lite:all-included-schemas(.)"/>
    </xsl:for-each>
  </xsl:function>

  <xsl:function name="lite:directly-included-schemas" as="element(xsdSchema)*">
    <xsl:param name="schema" as="element(xsdSchema)"/>
    <xsl:sequence select="
        $lite:direct-implicit-and-explicit-schema-include//
        lite:include[lite:including/@id = $schema/lite:schema-id(.)]/lite:included/@id/lite:resolve-schema-by-id(.)"/>
  </xsl:function>

  <xsl:function name="lite:directly-imported-schemas" as="element(xsdSchema)*">
    <xsl:param name="schema" as="element(xsdSchema)"/>
    <xsl:sequence select="
        $lite:direct-implicit-and-explicit-schema-import//
        lite:import[lite:importing/@id = $schema/lite:schema-id(.)]/lite:imported/@id/lite:resolve-schema-by-id(.)"/>
  </xsl:function>

  <xsl:function name="lite:schema-id" as="xs:string">
    <xsl:param name="schema" as="element()"/>
    <xsl:sequence select="concat(lite:namespace($schema), '/', lite:version($schema), '/', $schema/@schemaFile)"/>
  </xsl:function>

  <xsl:function name="lite:fachmodell-id" as="xs:string">
    <xsl:param name="object" as="element()"/>
    <xsl:sequence select="
        concat(
        $object/ancestor-or-self::xoev-fachmodell/metadaten.standard/kennung, '_',
        $object/ancestor-or-self::xoev-fachmodell/metadaten.versionStandard/version, '/')"/>
  </xsl:function>

  <!-- ToDo: Vorbereitet für spätere explizite Includes mittels @force. Sobald Klärung hierzu erfolgt, entweder bereinigen oder explizite Includes umsetzen. -->
  <xsl:variable name="lite:implicit-and-explicit-schema-include" as="element(lite:schema-include)">
    <lite:schema-include>
      <xsl:for-each select="$modelle/descendant::xsdSchema[not(@draft = 'true')]">
        <xsl:sort select="@schemaFile"/>
        <xsl:variable name="schema" select="."/>
        <xsl:variable name="explicitly-included-schemas" select="()"/>
        <xsl:for-each select="
            lite:used-schemas(.)[lite:namespace(.) = $schema/lite:namespace(.) and not(lite:schema-id(.) = $explicitly-included-schemas/lite:schema-id(.))],
            $explicitly-included-schemas">
          <xsl:sort select="lite:schema-id(.)"/>
          <lite:include>
            <lite:including schemaFile="{$schema/@schemaFile}" id="{$schema/lite:schema-id(.)}"/>
            <lite:included schemaFile="{@schemaFile}" id="{lite:schema-id(.)}"/>
          </lite:include>
        </xsl:for-each>
      </xsl:for-each>
    </lite:schema-include>
  </xsl:variable>

  <!-- ToDo: Vorbereitet für spätere explizite Importe mittels @force. Sobald Klärung hierzu erfolgt, entweder bereinigen oder explizite Importe umsetzen. -->
  <xsl:variable name="lite:implicit-and-explicit-schema-import" as="element(lite:schema-import)">
    <lite:schema-import>
      <xsl:for-each select="$modelle/descendant::xsdSchema[not(@draft = 'true')]">
        <xsl:sort select="@schemaFile"/>
        <xsl:variable name="schema" select="."/>
        <!-- Dummy Variable für explizite Importe. -->
        <xsl:variable name="explicitly-imported-schemas" select="()"/>
        <xsl:for-each select="
            lite:used-schemas(.)[lite:namespace(.) != $schema/lite:namespace(.) and not(lite:schema-id(.) = $explicitly-imported-schemas/lite:schema-id(.))],
            $explicitly-imported-schemas">
          <xsl:sort select="lite:schema-id(.)"/>
          <lite:import>
            <lite:importing schemaFile="{$schema/@schemaFile}" id="{$schema/lite:schema-id(.)}"/>
            <lite:imported schemaFile="{@schemaFile}" id="{lite:schema-id(.)}"/>
          </lite:import>
        </xsl:for-each>
      </xsl:for-each>
    </lite:schema-import>
  </xsl:variable>

  <xsl:variable name="lite:direct-implicit-and-explicit-schema-include" as="element(lite:direct-schema-include)">
    <lite:direct-schema-include>
      <xsl:variable name="includes" select="$lite:implicit-and-explicit-schema-include-closure"/>
      <xsl:for-each select="$includes//lite:include">
        <xsl:variable name="A" select="lite:including"/>
        <xsl:variable name="C" select="lite:included"/>
        <xsl:if test="
            not(
            some $id in $includes//@id
              satisfies (
              $includes//lite:include[lite:including/@id = $A/@id and lite:included/@id = $id] and
              $includes//lite:include[lite:including/@id = $id and lite:included/@id = $C/@id]))">
          <xsl:copy-of select="."/>
        </xsl:if>
      </xsl:for-each>
    </lite:direct-schema-include>
  </xsl:variable>

  <xsl:variable name="lite:direct-implicit-and-explicit-schema-import" as="element(lite:direct-schema-import)">
    <lite:direct-schema-import>
      <xsl:for-each select="$lite:implicit-and-explicit-schema-import//lite:import">
        <xsl:variable name="A" select="lite:importing"/>
        <xsl:variable name="C" select="lite:imported"/>
        <xsl:if test="
            not(
            some $id in $lite:implicit-and-explicit-schema-import//@id
              satisfies (
              $lite:implicit-and-explicit-schema-import//lite:import[lite:importing/@id = $A/@id and lite:imported/@id = $id] and
              $lite:implicit-and-explicit-schema-include-closure//lite:include[lite:including/@id = $id and lite:included/@id = $C/@id]))">
          <xsl:copy-of select="."/>
        </xsl:if>
      </xsl:for-each>
    </lite:direct-schema-import>
  </xsl:variable>

  <xsl:function name="lite:implicit-and-explicit-schema-include-closure" as="element(lite:schema-include)">
    <xsl:param name="schema-include" as="element(lite:schema-include)"/>
    <xsl:variable name="schema-include-duplicate-free">
      <lite:schema-include>
        <xsl:for-each-group select="$schema-include//*:include" group-by="concat(*:including/@id, ' ', *:included/@id)">
          <xsl:sequence select="."/>
        </xsl:for-each-group>
      </lite:schema-include>
    </xsl:variable>
    <xsl:variable name="new">
      <xsl:for-each select="$schema-include-duplicate-free//*:including">
        <xsl:variable name="A" select="."/>
        <xsl:for-each select="$schema-include-duplicate-free//*:include[*:including/@id = $A/@id]/*:included">
          <xsl:variable name="B" select="."/>
          <xsl:for-each select="$schema-include-duplicate-free//*:include[*:including/@id = $B/@id]/*:included">
            <xsl:variable name="C" select="."/>
            <xsl:if test="empty($schema-include-duplicate-free//*:include[*:including/@id = $A/@id and *:included/@id = $C/@id])">
              <lite:include>
                <lite:including schemaFile="{$A/@schemaFile}" id="{$A/@id}"/>
                <lite:included schemaFile="{$C/@schemaFile}" id="{$C/@id}"/>
              </lite:include>
            </xsl:if>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="empty($new//lite:include)">
        <xsl:sequence select="$schema-include-duplicate-free/lite:schema-include"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="next">
          <lite:schema-include>
            <xsl:copy-of select="$schema-include-duplicate-free//*:include"/>
            <xsl:sequence select="$new"/>
          </lite:schema-include>
        </xsl:variable>
        <xsl:sequence select="lite:implicit-and-explicit-schema-include-closure($next/lite:schema-include)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:variable name="lite:implicit-and-explicit-schema-include-closure" select="lite:implicit-and-explicit-schema-include-closure($lite:implicit-and-explicit-schema-include)"/>

  <xsl:variable name="lite:schemas-with-imports-and-includes" as="document-node(element(schemas-with-imports-and-includes))">
    <xsl:document>
      <schemas-with-imports-and-includes xmlns="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0">
        <xsl:for-each select="descendant::xsdSchema[not(@draft = 'true')]">
          <xsl:variable name="schema" select="."/>
          <schema-with-imports-and-includes id="{lite:schema-id(.)}">
            <xsl:for-each select="lite:directly-imported-schemas(.)">
              <xsl:variable name="imported-schema" select="."/>
              <xsl:variable name="import-prefix" select="$imported-schema/lite:prefix(., $schema)"/>
              <xsl:variable name="imported-namespace" select="$imported-schema/lite:namespace(.)"/>
              <import id="{$imported-schema/lite:schema-id(.)}" prefix="{$import-prefix}" namespace="{$imported-namespace}" schemaFile="{$imported-schema/@schemaFile}" kind="direct">
                <xsl:attribute name="schemaLocation" select="
                    ($imported-schema/@schemaLocation,
                    concat($imported-schema/(ancestor::xoev-fachmodell, ancestor::lite-bib:xoev-bibliothek)/konfiguration.xoev-fachmodell/schemaLocationBase, $imported-schema/@schemaFile))[1]"/>
              </import>
              <xsl:for-each select="lite:all-included-schemas($imported-schema)">
                <import id="{lite:schema-id(.)}" prefix="{$import-prefix}" namespace="{$imported-namespace}" schemaFile="{$imported-schema/@schemaFile}" kind="indirect"/>
              </xsl:for-each>
            </xsl:for-each>
            <xsl:for-each select="lite:directly-included-schemas(.)">
              <include id="{lite:schema-id(.)}" schemaFile="{@schemaFile}" kind="direct"/>
              <xsl:for-each select="lite:all-included-schemas(.)">
                <include id="{lite:schema-id(.)}" schemaFile="{@schemaFile}" kind="indirect"/>
              </xsl:for-each>
            </xsl:for-each>
          </schema-with-imports-and-includes>
        </xsl:for-each>
      </schemas-with-imports-and-includes>
    </xsl:document>
  </xsl:variable>
  <xsl:key name="lite:schemas-with-imports-and-includes" match="schema-with-imports-and-includes" use="@id"/>
  <xsl:function name="lite:schema-with-imports-and-includes" as="element(schema-with-imports-and-includes)?">
    <xsl:param name="schema" as="element()"/>
    <xsl:sequence select="key('lite:schemas-with-imports-and-includes', $schema/lite:schema-id(.), $lite:schemas-with-imports-and-includes)"/>
  </xsl:function>



  <!-- Diese character-map definiert Ersatzwerte zum unmaskierten Serialisieren von XML-Text. -->
  <xsl:character-map name="lite:_unescaped-xml-character-map">
    <xsl:output-character character="&#xE801;" string="&lt;"/>
    <xsl:output-character character="&#xE802;" string="&gt;"/>
    <xsl:output-character character="&#xE803;" string="&amp;"/>
  </xsl:character-map>

  <!-- Ersetzt in einem String diejenigen Zeichen, die normalerweise beim Serialisieren des XML-Baums maskiert werden müssen,
      durch Codes aus der UNICODE Range E000–F8FF, welche zur "privaten Nutzung" reserviert sind.
      Wenn in xsl:output die dazugehörige character-map "_unescaped-character-map" verwendet wird,
      werden die so ersetzten Zeichen ohne weitere Maskierung serialisiert.
      Siehe auch: http://www.xmlplease.com/charactermap#s2. -->

  <xsl:function name="lite:unescaped-xml" as="xs:string">
    <xsl:param name="string" as="xs:string"/>
    <xsl:value-of select="translate($string, '&lt;&gt;&amp;', '&#xE801;&#xE802;&#xE803;')"/>
  </xsl:function>

  <xsl:function name="lite:clean-text" as="xs:string">
    <xsl:param name="string"/>
    <xsl:value-of select="normalize-space(replace(replace(replace(replace($string, 
         '&lt;[^&lt;!][^&lt;]+[^-]&gt;', ''),
         '&amp;ndash;','-'),
         '&amp;([^;]+);', '$1'),
         '&lt;!--[^&gt;]*--&gt;',''))"/>
  </xsl:function>

  <xsl:function name="lite:get-duplicate-strings" as="xs:string*">
    <xsl:param name="seq" as="xs:string*"/>
    <xsl:for-each select="$seq[index-of($seq, .)[2]]">
      <xsl:sequence select="."/>
    </xsl:for-each>
  </xsl:function>

</xsl:stylesheet>
