<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


  <xd:doc scope="stylesheet">
    <xd:desc>
      <xd:p>Dieses Stylesheet dient der Abbildung einer Eigenschaftentabelle von Nachrichten, komplexen Datentypen, globalen Eigenschaften und globalen Eigenschaftengruppen.</xd:p>
    </xd:desc>
  </xd:doc>

  <!-- Abstandhalter zwischen Bezeichnung, Icon und Multiplizität, Breite 1 en : -->
  <xsl:variable name="gruppe-icon-separator" select="'&#x2002;'"/>
  <!-- falls größerer Abstand erwünscht: 1 em = &#x2003; -->

  <xd:doc>
    <xd:desc>
      <xd:p>Erzeuge die Eigenschaft-Tabelle für einen Baustein (Nachricht, Datentyp, globale Eigenschaftengruppe oder globale Eigenschaft).</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft" mode="lite:dokumentation.eigenschaften">

    <!-- Die Tabelle wird nur dann erzeugt, wenn es mindestens eine "eigenschaft" oder "eigenschaftengruppe" gibt,
			die nicht den Status "draft" hat. -->
    <xsl:if test="eigenschaft[not(@draft = 'true')] | eigenschaftengruppe[not(@draft = 'true')] | anyStruktur[not(@draft = 'true')]">

      <!-- Deaktiviere für Tabelle Präfix bei Querverweisen ("Abschnitt") -->
      <xsl:text>:!section-refsig:&#x0A;&#x0A;</xsl:text>

      <xsl:value-of select="concat('.Struktur von ', (@titel, @name)[1], '&#x0A;')"/>
      <xsl:text>[cols="3%,3%,3%,3%,3%,3%,18%,35%,6%,8%,9%"]&#x0A;</xsl:text>
      <!-- in mm: 5mm,5mm,5mm,5mm,5mm,5mm,27mm,55mm,10mm,12mm,14mm,12mm (letzte Spalte = Seitenzahl, nicht bei adoc) -->
      <xsl:value-of select="concat('[id=table.', lite:docbook-id(.), ']&#x0A;')"/>
      <xsl:text>|===&#x0A;</xsl:text>
      <xsl:text>11+^|`*</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.gruppenattribute">
        <xsl:with-param name="kinderlos" select="false()"/>
      </xsl:apply-templates>
      <xsl:text>*`&#x0A;</xsl:text>
      <xsl:text>7+h|Kindelement</xsl:text>
      <xsl:if test="eigenschaft[not(@draft = 'true')][@xsdAttribute = 'true']">/Attribut</xsl:if>
      <xsl:text> h|Typ / Basistyp / Referenz h| ++&#x2003;++ ^h|Anz. ^h|Ref.&#x0A;&#x0A;</xsl:text>

      <xsl:for-each select="eigenschaft[not(@draft = 'true')] | eigenschaftengruppe[not(@draft = 'true')] | anyStruktur[not(@draft = 'true')]">
        <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag">
          <xsl:with-param name="indent" select="0"/>
        </xsl:apply-templates>
      </xsl:for-each>
      <xsl:text>|===&#x0A;&#x0A;</xsl:text>

      <!-- Reaktiviere für Tabelle Präfix bei Querverweisen ("Abschnitt") -->
      <xsl:text>:section-refsig: Abschnitt&#x0A;&#x0A;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Erzeuge einen Eintrag der Eigenschaften-Tabelle (rekursiv)</xd:p>
    </xd:desc>
    <xd:param name="indent">Einrückungstiefe</xd:param>
  </xd:doc>
  <xsl:template match="eigenschaft | eigenschaftengruppe | anyStruktur" mode="lite:dokumentation.eigenschaften.tabelleneintrag">
    <xsl:param name="indent" as="xs:integer" required="yes"/>

    <!-- 
      Falls es notwendig ist, AsciiDoc-Blöcke in das Dokumentationsfeld aufzunehmen, 
    muss die Tabellenzelle das Präfix a erhalten und ggf. müssen die entsprechenden Inhalte besonders behandelt werden.
    
    Ist bisher möglich bei Geschäftsregeln sowie verschiedenen Docbook-Elementen im Beschreibungselement.
    Für itemizedList wurde ein Workaround ohne Block erstellt.
    
    Ggf. müssen weitere Elemente in select aufgenommen werden.
    -->
    <xsl:variable name="hatBlockinhalt" select="not(empty(geschaeftsregel))" as="xs:boolean"/>
    <!--	  <xsl:variable name="hatBlockinhalt" select="not(empty(geschaeftsregel)) or .//db:informaltable" as="xs:boolean"/>-->

    <!-- In dieser Variable werden potentielle Inhalte für das Dokumentationsfeld gesammelt.
		Anschließend kann geprüft werden, ob sich Inhalte in der Variablen befinden. 
		Wenn ja, wird der Inhalt in das Feld eingefügt. Wenn nein, entfällt die Dokumentationszeile. 
		Die Variable wird schon an dieser Stelle angelegt, damit geprüft werden kann, ob nach der letzten Eigenschaftszeile
		mit Bezeichnung, Typ, Anzahl, Referenz eine Zeilenbegrenzung eingezogen werden muss.
		-->
    <xsl:variable name="dokumentation">
      <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.dokumentation">
        <xsl:with-param name="hatBlockinhalt" select="$hatBlockinhalt" as="xs:boolean" tunnel="yes"/>
      </xsl:apply-templates>
    </xsl:variable>

    <!-- Kennzeichnet nicht-anonymen Datentyp -->
    <xsl:variable name="eigenschaftIstKinderlos" select="empty(eigenschaft) and empty(eigenschaftengruppe)"/>

<!--    <xsl:variable name="eigenschaftHatKeineAngabenFuerDasDokumentationsfeld" select="normalize-space($dokumentation) = ''"/>-->

    <!-- Erzeugt die Zeile mit den Kerninformationen des Kindelements (Bezeichnung, Typ, Anzahl, Referenz (Kapitel und Seite)) -->

    <!-- 7 = Maximale Spaltenzahl für Name des Kindelements  -->

    <!-- Zu tiefe Verschachtelung wird mit Fehlermeldung versehen und nicht weiter eingerückt.
	  TODO: wird bisher nicht verwendet!
	  -->
    <xsl:variable name="zuTiefVerschachtelt" select="$indent &gt; 6" as="xs:boolean"/>

    <!-- mindestens eine Spalte muss für den Namen übrigbleiben -->
    <xsl:variable name="spannedNameCols" select="max((7 - $indent, 1))"/>

    <!-- auf oberster Ebene beginnt der Name des Kindelements in der ersten Spalte, daher keine leeren Zellen,
	  mindestens eine Spalte muss für den Namen übrigbleiben, daher Einrückung maximal 6 Spalten -->
    <xsl:variable name="spannedEmptyCols" select="7 - $spannedNameCols"/>

    <!-- Einrückung -->
    <xsl:value-of select="
        if ($spannedEmptyCols &gt; 0) then
          concat($spannedEmptyCols, '+| ')
        else
          ''"/>

    <!-- Feld für Bezeichnung und Gruppenart -->
    <xsl:value-of select="concat($spannedNameCols, '+|')"/>
    <!-- Bezeichnung -->
    <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.bezeichnung"/>

    <!-- Art und Multiplizität impliziter und expliziter Gruppe -->
    <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.gruppenattribute">
      <xsl:with-param name="kinderlos" select="$eigenschaftIstKinderlos"/>
    </xsl:apply-templates>

    <!-- Feld für Datentyp, referenzierte globale Eigenschaft/Eigenschaftengruppe oder Basistyp -->
    <xsl:choose>
      
      <xsl:when test="@typ">
        <xsl:value-of select="concat('|`*', lite:kuerze-internen-typnamen(@typ, ., false()), '*`')"/>
        <xsl:text> ^|</xsl:text>
        <xsl:copy-of select="
            lite:gibStrukturIcon(if (lite:is-simple-type(lite:resolve(@typ, ., false()))) then
              'type_simple'
            else
              'type_complex')"/>
      </xsl:when>
      
      <xsl:when test="@referenz">
        <xsl:value-of select="concat('|`*', lite:kuerze-internen-typnamen(@referenz, ., true()), '*`')"/>
        <xsl:text> ^|</xsl:text>
        <xsl:copy-of select="
            lite:gibStrukturIcon(
            if (lite:resolve(@referenz, ., true())/@xsdAttribute = true()) then
              'ref_attribute'
            else
              if (lite:is-element-group(lite:resolve(@referenz, ., true()))) then
                'ref_element_group'
              else
                if (lite:is-attribute-group(lite:resolve(@referenz, ., true()))) then
                  'ref_attribute_group'
                else
                  'ref_element'
            )"/>
      </xsl:when>
      
      <xsl:when test="@basistyp">
        <xsl:value-of select="concat('|`*', lite:kuerze-internen-typnamen(@basistyp, ., false()), '*`')"/>
        <xsl:text> ^|</xsl:text>
        <xsl:copy-of select="lite:gibStrukturIcon('basistyp')"/>
      </xsl:when>
      
      <xsl:otherwise>
        <xsl:text>||</xsl:text>
      </xsl:otherwise>
      
    </xsl:choose>

    <!-- Feld für Multiplizität (nur für Eigenschaften, keine impliziten oder expliziten Gruppen) -->
    <xsl:text> ^|</xsl:text>
    <xsl:if test="self::eigenschaft">
      <xsl:value-of select="concat('*', translate((@multiplizitaet, '1')[1], '*', 'n'), '*')"/>
    </xsl:if>

    <!-- Feld für Verlinkung (Abschnitt) -->

    <xsl:choose>
      <!-- Achtung: Dieser Test per Helperfunktion funktioniert nicht! -->
      <!-- <xsl:when test="@typ and lite:is-simple-type(lite:resolve(@typ, ., false())) = false()"> -->

      <xsl:when test="@typ and not(starts-with(@typ, 'xs:'))">
        <!-- Verweis auf Datentyp, außer W3C-Datentyp -->
        <!-- Abschnittsnummer -->
        <xsl:variable name="zielbaustein" select="lite:resolve(@typ, ., false())"/>
        <xsl:variable name="bausteinpfad" select="lite:baustein-pfad($zielbaustein)"/>
        <xsl:variable name="bausteinid" select="lite:docbook-id($zielbaustein)"/>
        <!-- Bei Erzeugung des gesamten Dokuments wird ein interner Link erzeugt, beim Einzeldokument ein externer Link -->
        <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat(' ^|xref:#', $bausteinid, '[]&#x0A;')"/>
        <xsl:text>endif::[]&#x0A;</xsl:text>
        <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
        <!--				  <xsl:value-of select="concat(' ^|xref:', $bausteinpfad,'.adoc#',$bausteinid,'[Link]&#x0A;')"/>-->
        <xsl:choose>
<!--          <xsl:when test="lite:reference-is-from-external-model(@typ)">-->
          <xsl:when test="lite:reference-is-from-external-model($zielbaustein)">
            <!-- Link zum Abschnitt "Externe Modelle = immer Link zu separater Datei, 
              wenn nicht volle Spezifikation erzeugt wird -->
            <xsl:value-of select="concat(' ^|xref:', $bausteinpfad, '[Link]&#x0A;')"/>
          </xsl:when>
          <xsl:otherwise>
            <!-- Linkziel könnte in separater oder gleicher Datei liegen, daher muss der Anker mitgegeben werden. -->
            <!-- Problem: führt immer zu separater Datei, auch wenn der Zielbaustein mit inkludiert ist.
            kann vermutlich an dieser Stelle nicht unterschieden werden. -->
            <xsl:value-of select="concat(' ^|xref:', $bausteinpfad, '.adoc#', $bausteinid, '[Link]&#x0A;')"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>endif::[]&#x0A;</xsl:text>
      </xsl:when>

      <xsl:when test="@referenz">
        <!-- Verweis auf globale Eigenschaft -->
        <!-- Abschnittsnummer -->
        <xsl:variable name="zielbaustein" select="lite:resolve(@referenz, ., true())"/>
        <xsl:variable name="bausteinpfad" select="lite:baustein-pfad($zielbaustein)"/>
        <xsl:variable name="bausteinid" select="lite:docbook-id($zielbaustein)"/>
        <!-- Bei Erzeugung des gesamten Dokuments wird ein interner Link erzeugt, beim Einzeldokument ein externer Link -->
        <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat(' ^|xref:#', $bausteinid, '[]&#x0A;')"/>
        <xsl:text>endif::[]&#x0A;</xsl:text>
        <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat(' ^|xref:', $bausteinpfad, '.adoc#', $bausteinid, '[Link]&#x0A;')"/>
        <xsl:text>endif::[]&#x0A;</xsl:text>

      </xsl:when>

      <xsl:otherwise>
        <!-- Sonstiges (Elemente mit anonymen Datentypen oder XML-Schema-Datentypen) -->
        <xsl:text>|&#x0A;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <!-- Dokumentationsfeld nur dann erzeugen, falls Inhalt vorhanden -->
    <xsl:if test="not(normalize-space($dokumentation) = '')">
      <!-- Dokufeld anlegen -->

      <!-- Einrückung -->
      <xsl:value-of select="
          if ($spannedEmptyCols &gt; 0) then
            concat($spannedEmptyCols, '+| ')
          else
            ''"/>

      <!-- Jetzt wird das Dokufeld gefüllt ... -->

      <!-- Wenn das Dokumentationsfeld Blöcke beinhaltet (z.B. Tabellen), 
		    muss ihm der Asciidoc-Stil (Präfix "a") zugewiesen werden. -->
      <xsl:value-of select="
          concat($spannedNameCols + 4, if ($hatBlockinhalt) then
            '+a|'
          else
            '+|', $dokumentation, '&#x0A;')"/>
    </xsl:if>

    <!-- Rekursives Durchlaufen der Kindelemente -->
    <xsl:for-each select="(eigenschaft | eigenschaftengruppe)">
      <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag">
        <xsl:with-param name="indent" select="$indent + 1"/>
      </xsl:apply-templates>
    </xsl:for-each>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template stellt die Art und die Multiplizität für implizite und explizite Gruppen dar.</xd:p>
      <xd:p>implizit: eigenschaft/@gruppe.art und eigenschaft/@gruppe.multiplizitaet</xd:p>
      <xd:p>explizit: eigenschaftengruppe/@art und eigenschaftengruppe/@multiplizitaet</xd:p>
    </xd:desc>
    <xd:param name="kinderlos">true, wenn keine Unterelemente eigenschaft oder eigenschaftengruppe vorhanden sind</xd:param>
  </xd:doc>
  <xsl:template match="*" mode="lite:dokumentation.eigenschaften.tabelleneintrag.gruppenattribute">
    <xsl:param name="kinderlos" as="xs:boolean"/>

    <xsl:choose>

      <xsl:when test="self::eigenschaft and not($kinderlos)">
        <!-- Für Eigenschaften mit anonymen Typen: -->
        <xsl:value-of select="
            if (./@name) then
              $gruppe-icon-separator
            else
              ''"/>
        <xsl:copy-of select="lite:gibStrukturIcon((@gruppe.art, 'sequence')[1])"/>
        <xsl:value-of select="concat($gruppe-icon-separator, translate((@gruppe.multiplizitaet, '1')[1], '*', 'n'))"/>
      </xsl:when>

      <xsl:when test="self::eigenschaftengruppe">
        <!-- Für jedwede Eigenschaftengruppe: -->
        <!-- RÜCKFRAGE: bei eigenschaftengruppen, die auf globaleEigenschaftengruppe referenzieren 
				Gruppeneigenschaften hier anzeigen? -->
        <xsl:value-of select="
            if (./@name) then
              $gruppe-icon-separator
            else
              ''"/>
        <xsl:copy-of select="lite:gibStrukturIcon((@art, 'sequence')[1])"/>
        <xsl:value-of select="concat($gruppe-icon-separator, translate((@multiplizitaet, '1')[1], '*', 'n'))"/>
      </xsl:when>

      <xsl:when test="self::nachricht or self::datentyp or self::globaleEigenschaft or self::globaleEigenschaftengruppe">
        <!-- Für den Tabellenkopf Gruppeneigenschaften des Bausteins: -->
        <xsl:value-of select="$gruppe-icon-separator"/>
        <xsl:copy-of select="lite:gibStrukturIcon((@gruppe.art,@art,'sequence')[1])"/>
        <xsl:value-of select="concat($gruppe-icon-separator, translate((@multiplizitaet, '1')[1], '*', 'n'))"/>
      </xsl:when>

    </xsl:choose>
  </xsl:template>


  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template gibt die Bezeichnung der Eigenschaft aus.</xd:p>
      <xd:p>Referenzierte globale Eigenschaften und Eigenschaftengruppen werden nicht als Bezeichnung, sondern als Typ eingetragen.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="eigenschaft | eigenschaftengruppe | anyStruktur" mode="lite:dokumentation.eigenschaften.tabelleneintrag.bezeichnung">
    <xsl:choose>
      <xsl:when test="@xsdAttribute = 'true'">
        <xsl:if test="not(@referenz)">
          <xsl:copy-of select="lite:gibStrukturIcon('attribute')"/>
          <!-- auch bei adoc ist nur eine Verschachtelungs-Reihenfolge möglich, aber genau umgekehrt zu Docbook:
				  außen bold, innen italics -->
        <xsl:value-of select="concat('*_', @name, '_* ')"/>
        </xsl:if>
      </xsl:when>
      <xsl:when test="not(@name)">
        <xsl:text>*_unbenannt_* </xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat('*', @name, '*')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template sammelt Informationen, die im Dokumentationsfeld ausgegeben werden können.</xd:p>
      <xd:p>TODO: Prüfen, welche Informationen aus der referenzierten globalen Eigenschaft(engruppe) übernommen werden sollen, falls hier in der Eigenschaft(engruppe) keine vorhanden sind.</xd:p>
    </xd:desc>
    <xd:param name="hatBlockinhalt">Dokumentationsfeld enthält Docbook-Elemente, die in AsciiDoc Blöcken entsprechen.</xd:param>
  </xd:doc>
  <xsl:template match="eigenschaft | eigenschaftengruppe | anyStruktur" mode="lite:dokumentation.eigenschaften.tabelleneintrag.dokumentation">
    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>

    <!-- 1. Titel -->
    <xsl:if test="@titel">
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '[small]#'
          else
            ''"/>
      <xsl:value-of select="concat('*Titel:* _', @titel, '_')"/>
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '#&#x0A;&#x0A;'
          else
            '&#x0A;&#x0A;'"/>
    </xsl:if>

    <!-- 2. Beschreibung (falls keine vorhanden, ggf. aus referenzierter globaler Eigenschaft(engruppe)) -->

    <!-- Der Parameter inTabelle gibt jeweils an, dass es sich um das Element Beschreibung innerhalb der Eigenschaftentabelle handelt und nicht um die Beschreibung des Bausteins. Dadurch werden bestimmte Inhalte nicht verarbeitet bzw. besonders behandelt. -->
    <xsl:choose>
      <xsl:when test="not(empty(beschreibung))">
        <xsl:apply-templates select="beschreibung" mode="lite:dokumentation.FliesstextUndDocBookType">
          <xsl:with-param name="inTabelle" select="true()" tunnel="yes"/>
        </xsl:apply-templates>
        <xsl:text>&#x0A;&#x0A;</xsl:text>
      </xsl:when>
      <xsl:when test="empty(beschreibung) and @referenz">
        <!-- Beschreibung aus referenzierter globaler Eigenschaft übernommen -->
        <xsl:apply-templates select="lite:resolve(@referenz, ., true())/beschreibung" mode="lite:dokumentation.FliesstextUndDocBookType">
          <xsl:with-param name="inTabelle" select="true()" tunnel="yes"/>
        </xsl:apply-templates>
        <xsl:text>&#x0A;&#x0A;</xsl:text>
      </xsl:when>
    </xsl:choose>

    <!-- 3. Fixed- und Default-Wert -->
    <xsl:if test="@fixedWert">
      <xsl:value-of select="concat('In diesem Element/Attribut ist nur der Wert &quot;', @fixedWert, '&quot; zulässig (fixed-Wert).&#x0A;&#x0A;')"/>
    </xsl:if>
    <xsl:if test="@defaultWert">
      <xsl:value-of select="concat('Dieses Element/Attribut hat den Wert &quot;', @defaultWert, '&quot;, sofern kein anderer Wert übermittelt wird (default-Wert).&#x0A;&#x0A;')"/>
    </xsl:if>

    <!-- 4. Umsetzungshinweis -->

    <!-- Der Parameter inTabelle gibt an, dass es sich um das Element Umsetzungshinweis innerhalb der Eigenschaftentabelle handelt und nicht um den Umsetzungshinweis des Bausteins. Dadurch werden bestimmte Inhalte nicht verarbeitet bzw. besonders behandelt. -->
    <xsl:if test="umsetzungshinweis">
      <xsl:apply-templates select="umsetzungshinweis" mode="lite:dokumentation.FliesstextUndDocBookType">
        <xsl:with-param name="inTabelle" select="true()" tunnel="yes"/>
      </xsl:apply-templates>
      <xsl:text>&#x0A;&#x0A;</xsl:text>
    </xsl:if>


    <!-- 5. Beispielwert -->

    <!-- TODO Templates für Beispielwert und Umsetzungshinweis unterschiedlich aufgebaut (bzgl. if und Zeilenumbruch), vereinheitlichen! -->
    <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.beispielwert"/>
    <xsl:text>&#x0A;&#x0A;</xsl:text>


    <!-- 6. Form (falls angegeben und vom Defaultwert abweichend) -->
    <xsl:if test="@form and not(@form = /xoev-fachmodell/konfiguration.xoev-fachmodell/elementFormDefault)">
      <xsl:value-of select="concat('Form (Qualifizierung): ', @form, '&#x0A;&#x0A;')"/>
    </xsl:if>

    <!-- 7. Angaben zur Ableitung (pattern, maxLength etc.) -->
    <!-- Ableitungsattribute, die in der Eigenschaft selbst angegeben sind -->
    <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.tabelleneintrag.ableitung"/>

    <!-- Ableitungsattribute, die in der referenzierten globalen Eigenschaft angegeben sind (noch zu klären, ob erwünscht) -->
    <xsl:apply-templates select="lite:resolve(@referenz, ., true())" mode="lite:dokumentation.eigenschaften.tabelleneintrag.ableitung"/>


    <!-- 8. Angaben für anyStruktur -->
    <xsl:if test="@namespace">
      <xsl:value-of select="concat('*Namensraum:* ', @namespace, '&#x0A;&#x0A;')"/>
    </xsl:if>
    <xsl:if test="@processContents">
      <xsl:value-of select="concat('*Art der Validierung:* ', @processContents, '&#x0A;&#x0A;')"/>
    </xsl:if>

    <!-- 9. Angaben für union -->
    <xsl:apply-templates select="union" mode="lite:dokumentation.eigenschaften.tabelleneintrag"/>

    <!-- 10. Angaben für Geschäftsregel -->
    <xsl:if test="geschaeftsregel">
      <xsl:apply-templates select="." mode="lite:dokumentation.eigenschaften.geschaeftsregeln">
        <xsl:with-param name="hatBlockinhalt" select="$hatBlockinhalt" as="xs:boolean" tunnel="yes"/>
      </xsl:apply-templates>
    </xsl:if>

  </xsl:template>


  <xd:doc>
    <xd:desc>Dieses Template verarbeitet Angaben zur Ableitung eines Datentyps einer Eigenschaft.</xd:desc>
    <xd:param name="hatBlockinhalt">wenn wahr: Beispielwert befindet sich in einer Tabellenzelle mit Elementen, die AsciiDoc-Blöcke sind.</xd:param>
  </xd:doc>
  <xsl:template match="*" mode="lite:dokumentation.eigenschaften.tabelleneintrag.ableitung">
    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>

    <!-- Größtenteils übernommen von baustein_in_paketstruktur.xsl -->

    <xsl:if test="@basistyp">
      <xsl:variable name="basistyp" select="lite:resolve(@basistyp, ., false())"/>
      <xsl:variable name="isRestriction" select="
          if (@restriction[. = 'true']) then
            true()
          else
            false()"/>

      <!-- a) Vererbungsinfo generieren (Einschränkung oder Erweiterung; ggf. Querreferenz im Dokument) -->
      <xsl:value-of select="
          concat(
          if ($hatBlockinhalt) then
            '[small]#'
          else
            '',
          'Der Typ dieses Elements ist eine ', if ($isRestriction) then
            'Einschränkung'
          else
            'Erweiterung',
          ' des Basistyps `*', $basistyp/@name,
          '*`'
          )"/>

      <xsl:if test="not(starts-with(@basistyp, 'xs:'))">
        <!-- Bei Erzeugung des gesamten Dokuments wird ein interner Link erzeugt, 
				    beim Einzeldokument ein externer Link -->
        <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat(' (siehe xref:#', lite:docbook-id(lite:resolve(@basistyp, ., false())), '[])&#x0A;')"/>
        <xsl:text>endif::[]&#x0A;</xsl:text>
        <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat(' (siehe xref:', lite:baustein-pfad(lite:resolve(@basistyp, ., false())), '.adoc[hier])&#x0A;')"/>
        <xsl:text>endif::[]&#x0A;</xsl:text>
      </xsl:if>
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '.#&#x0A;&#x0A;'
          else
            '.&#x0A;&#x0A;'"/>

      <!-- b) Patterns, if any -->
      <xsl:variable name="pattern" as="xs:string*">+++<xsl:value-of select="@pattern"/>+++</xsl:variable>
      <!--	aus lite2db:
        <xsl:variable name="pattern" as="xs:string*"><![CDATA[<![CDATA[]]><xsl:value-of select="@pattern"/>]]&gt;</xsl:variable>
      -->

      <!-- TODO: prüfen, ob das Escaping sowohl in HTML als auch in pdf korrekt funktioniert -->
      <xsl:if test="@pattern[. != '']">
        <xsl:value-of select="
            concat(
            if ($hatBlockinhalt) then
              '[small]#'
            else
              '',
            'Die Werte müssen dem Muster ''', lite:unescaped-xml(string-join($pattern, '')), ''' entsprechen.',
            if ($hatBlockinhalt) then
              '#&#x0A;&#x0A;'
            else
              '&#x0A;&#x0A;')"/>
      </xsl:if>

      <!-- c) Facets, if any -->
      <xsl:variable name="facets" select="
          (@fractionDigits, @length, @maxExclusive, @maxInclusive, @maxLength,
          @minExclusive, @minInclusive, @minLength, @totalDigits, @whitespace)"/>
      <xsl:if test="$facets">
        <xsl:value-of select="
            concat(if ($hatBlockinhalt) then
              '[small]#'
            else
              '',
            'Beschränkungen (XML-Schema-Facetten): ')"/>
        <xsl:for-each select="$facets">
          <xsl:value-of select="concat(name(), ':', .)"/>
          <xsl:if test="position() != last()">
            <xsl:text>, </xsl:text>
          </xsl:if>
        </xsl:for-each>
        <xsl:value-of select="
            if ($hatBlockinhalt) then
              '#&#x0A;&#x0A;'
            else
              '&#x0A;&#x0A;'"/>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:desc>Dieses Template verarbeitet das Element union innerhalb einer Eigenschaft.</xd:desc>
  </xd:doc>
  <xsl:template match="union" mode="lite:dokumentation.eigenschaften.tabelleneintrag">
    <xsl:text>Der Typ dieser Eigenschaft ist eine Vereinigung folgender Datentypen:&#x0A;&#x0A;</xsl:text>
    <xsl:for-each select="memberType">
      <xsl:value-of select="concat('&#x2022; ', ., ' +&#x0A;')"/>
    </xsl:for-each>

    <xsl:text>&#x0A;&#x0A;</xsl:text>
  </xsl:template>

  <xd:doc scope="component">
    <xd:desc>
      <xd:p>Dieses Template erzeugt einen Eintrag mit einem oder mehreren Beispielwerten, sofern vorhanden.</xd:p>
    </xd:desc>
    <xd:param name="hatBlockinhalt">wenn wahr: Beispielwert befindet sich in einer Tabellenzelle mit Elementen, die AsciiDoc-Blöcke sind.</xd:param>
  </xd:doc>
  <xsl:template match="*" mode="lite:dokumentation.eigenschaften.beispielwert">
    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>
    <!-- Aufbau des Templates aus baustein_in_paketstruktur.xsl übernommen, könnte in uebersetzungsanweisungen.common-templates.xsl zusammengefasst werden. -->
    <xsl:if test="beispielwert">
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '[small]#'
          else
            ''"/>
      <xsl:value-of select="
          if (count(beispielwert) = 1) then
            'Beispielwert: '
          else
            'Beispielwerte: '"/>
      <xsl:value-of select="string-join(beispielwert, ', ')"/>
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '#&#x0A;&#x0A;'
          else
            '&#x0A;&#x0A;'"/>
    </xsl:if>
  </xsl:template>

  <xd:doc>
    <xd:desc>
      <xd:p>Erzeuge eine Tabelle mit Geschäftsregeln.</xd:p>
    </xd:desc>
    <xd:param name="hatBlockinhalt">wenn wahr: Beispielwert befindet sich in einer Tabellenzelle mit Elementen, die AsciiDoc-Blöcke sind.</xd:param>
  </xd:doc>
  <xsl:template match="eigenschaft" mode="lite:dokumentation.eigenschaften.geschaeftsregeln">
    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>
    <xsl:variable name="zwsp" select="'&#x200B;'"/>

    <!-- Die Tabelle wird nur dann erzeugt, wenn es mindestens eine "geschaeftsregel" gibt. -->
    <xsl:if test="geschaeftsregel">
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '[small]#'
          else
            ''"/>
      <xsl:text>*Geschäftsregeln*</xsl:text>
      <xsl:value-of select="
          if ($hatBlockinhalt) then
            '#&#x0A;&#x0A;'
          else
            '&#x0A;&#x0A;'"/>

      <xsl:value-of select="concat('[id=table.', lite:docbook-id(.), '.rules]&#x0A;')"/>
      <xsl:text>[cols="13%,87%"]&#x0A;</xsl:text>
      <xsl:text>!===&#x0A;</xsl:text>
      <xsl:text>!ID!Regel / XPath&#x0A;&#x0A;</xsl:text>
      <xsl:for-each select="geschaeftsregel">
        <xsl:sort select="@kennung"/>
        <!-- Liefert die @kennung zurück, aber mit einem "zero width space (ZWSP)" zwischen den einzelnen Buchstaben.
											  Damit wird ein Trennalgorithmus beim Setzen des Dokuments gezielt ausgehebelt.-->
        <xsl:value-of select="concat('.2+!', replace(@kennung, '(.)', concat('$1', $zwsp)))"/>
        <!-- Beschreibung einer Geschäftsregel ist nur String, im Gegensatz zu Bausteinen und Eigenschaften. -->
        <xsl:value-of select="concat('!', beschreibung)"/>
        <!--		  <xsl:text>!</xsl:text>-->
        <!--		  <xsl:text>!</xsl:text><xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>-->
        <xsl:value-of select="concat('!`*', spezifikation, '*` &#x0A;')"/>
      </xsl:for-each>
      <xsl:text>!===&#x0A;&#x0A;</xsl:text>
    </xsl:if>

    <!-- Zu klären: Darstellung von  -->
    <!-- 
			<para>Verbindlichkeit: <xsl:value-of select="@verbindlichkeit"/></para>
			<para>Auswertungskontext: <xsl:value-of select="auswertungskontext"/></para>
			<para>Fachkontext: <xsl:value-of select="fachkontext"/></para>
		-->
  </xsl:template>


  <xd:doc>
    <xd:desc> Diese Funktion erzeugt Icons für bestimmte Strukturelemente.</xd:desc>
    <xd:param name="strukturtyp">
      <xd:p>String, der das Strukturelement bezeichnet. Momentan unterstützt:</xd:p>
      <xd:p>
        <xd:ul>
          <xd:li><xd:b>sequence</xd:b> Gruppenart sequence</xd:li>
          <xd:li><xd:b>choice</xd:b> Gruppenart choice</xd:li>
          <xd:li><xd:b>all</xd:b> Gruppenart all</xd:li>
          <xd:li><xd:b>attribute</xd:b> Attribut</xd:li>
          <xd:li><xd:b>typ</xd:b> Datentyp</xd:li>
          <xd:li><xd:b>basistyp</xd:b> Basistyp</xd:li>
          <xd:li><xd:b>type_simple</xd:b> nutztEinfachenDatentyp</xd:li>
          <xd:li><xd:b>type_complex</xd:b> nutztKomplexenDatentyp</xd:li>
          <xd:li><xd:b>ref_element</xd:b> nutztGlobalesElement</xd:li>
          <xd:li><xd:b>ref_attribute</xd:b> nutztGlobalesAttribut</xd:li>
          <xd:li><xd:b>ref_element_group</xd:b> nutztGlobaleElementgruppe</xd:li>
          <xd:li><xd:b>ref_attribute_group</xd:b> nutztGlobaleAttributgruppe</xd:li>
        </xd:ul>
      </xd:p>
    </xd:param>
  </xd:doc>
  <xsl:function name="lite:gibStrukturIcon">
    <xsl:param name="strukturtyp" as="xs:string"/>

    <xsl:variable name="Dateiname">
      <xsl:choose>
        <xsl:when test="$strukturtyp = 'sequence'">gruppenart&#x20;sequenz</xsl:when>
        <xsl:when test="$strukturtyp = 'choice'">gruppenart&#x20;auswahl</xsl:when>
        <xsl:when test="$strukturtyp = 'all'">gruppenart&#x20;alle</xsl:when>
        <xsl:when test="$strukturtyp = 'attribute'">attribut</xsl:when>
        <xsl:when test="$strukturtyp = 'typ'">einfacher&#x20;datentyp</xsl:when>
        <xsl:when test="$strukturtyp = 'basistyp'">basistyp_GR</xsl:when>
        <xsl:when test="$strukturtyp = 'type_simple'">nutztEinfachenDatentyp</xsl:when>
        <xsl:when test="$strukturtyp = 'type_complex'">nutztKomplexenDatentyp</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_element'">nutztGlobalesElement</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_attribute'">nutztGlobalesAttribut</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_element_group'">nutztGlobaleElementgruppe</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_attribute_group'">nutztGlobaleAttributgruppe</xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="Alternativtext">
      <xsl:choose>
        <xsl:when test="$strukturtyp = 'sequence'">Sequence</xsl:when>
        <xsl:when test="$strukturtyp = 'choice'">Choice</xsl:when>
        <xsl:when test="$strukturtyp = 'all'">All</xsl:when>
        <xsl:when test="$strukturtyp = 'attribute'">@</xsl:when>
        <xsl:when test="$strukturtyp = 'typ'">Typ</xsl:when>
        <xsl:when test="$strukturtyp = 'basistyp'">Basistyp</xsl:when>
        <xsl:when test="$strukturtyp = 'type_simple'">einf. Datentyp</xsl:when>
        <xsl:when test="$strukturtyp = 'type_complex'">kplx. Datentyp</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_element'">glob. Element</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_attribute'">glob. Attribut</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_element_group'">glob. Elementgruppe</xsl:when>
        <xsl:when test="$strukturtyp = 'ref_attribute_group'">glob. Attributgruppe</xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:sequence>
      <xsl:value-of select="concat('icon:', $Dateiname, '[', $Alternativtext, ', width=16]')"/>
    </xsl:sequence>
  </xsl:function>


</xsl:stylesheet>
