<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


  <!-- Einstiegspunkt für die Generierung -->
  <xsl:template match="/" mode="lite:code-datentyp-codelisten">
    <xsl:apply-templates select="xoev-fachmodell" mode="lite:code-datentyp-codelisten-uebersicht"/>
  </xsl:template>

  <!-- Erzeuge Übersicht Codelisten -->
  <xsl:template match="xoev-fachmodell" mode="lite:code-datentyp-codelisten-uebersicht">

    <xsl:variable name="document-directory" select="'dokumente/anhang/codeDatentypen'" as="xs:string"/>
    <xsl:variable name="target-document-directory" select="(concat($document-directory, '/', 'codeDatentypenTabelleGesamt.adoc'))" as="xs:string"/>
    <xsl:variable name="codeDatentypen_3" select="//codeDatentyp[@kennung][not(@version)][not(@draft = 'true')]"/>
    <xsl:variable name="codeDatentypen_1_2_4" select="//codeDatentyp[@kennung][@version][not(@draft = 'true')] | //codeDatentyp[not(@kennung)][not(@version)]"/>
    <xsl:variable name="fachmodell-kurz" select="//nameKurz" as="xs:string"/>
    <xsl:variable name="content">

      <xsl:text>= Übersicht Code-Datentypen&#x0A;&#x0A;</xsl:text>
      
      <xsl:text>ifndef::relfileprefix[]&#x0A;</xsl:text>
      <xsl:text>:relfileprefix: ../../&#x0A;</xsl:text>
      <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>

      <xsl:choose>
        <xsl:when test="empty($codeDatentypen_1_2_4) and empty($codeDatentypen_3)">

          <xsl:text>Hinweis: Dieser Standard enthält keine Code-Datentypen.&#x0A;&#x0A;</xsl:text>
          <!-- Datei wird erzeugt, aber Einbindung bleibt dem Standard überlassen. -->
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat('In diesem Abschnitt sind die in ', $fachmodell-kurz, ' verwendeten Code-Datentypen in der Übersicht dargestellt.&#x0A;&#x0A;')"/>

          <!-- Codelisten typ 3 -->
          <xsl:if test="exists($codeDatentypen_3)">

            <xsl:text>== Code-Typ 3&#x0A;&#x0A;</xsl:text>
            
            <xsl:text>In der nachstehenden Tabelle werden die folgenden Informationen dargestellt:&#x0A;&#x0A;</xsl:text>

            <xsl:text>Code-Datentyp:: Alle in </xsl:text>
            <xsl:value-of select="$fachmodell-kurz"/>
            <xsl:text> definierten Code-Datentypen des Typ 3 in alphabetischer Reihenfolge.&#x0A;</xsl:text>
            <xsl:text>Kennung:: Die Kennungfootnote:[Weitere Informationen zu den Metadaten einer Codeliste sind im aktuellen Codelisten-Handbuch beschrieben.] der im jeweiligen Code-Datentyp genutzten Codeliste.&#x0A;&#x0A;</xsl:text>

            <xsl:text>Die Namen der Code-Datentypen stellen Links zu den jeweiligen Detail-Abschnitten dar. Die Kennungen stellen Links zur jeweiligen Codeliste im XRepository dar.&#x0A;&#x0A;</xsl:text>

            <xsl:text>[id=code-uebersichtstabelle-typ3]&#x0A;</xsl:text>
            <xsl:text>[cols="40%,60%"]&#x0A;</xsl:text>
            <xsl:text>|===&#x0A;</xsl:text>
            <xsl:text>|Code-Datentyp|Kennung&#x0A;&#x0A;</xsl:text>
            <xsl:apply-templates select="$codeDatentypen_3" mode="lite:code-datentyp-3-codelisten">
              <xsl:sort select="@name"/>
            </xsl:apply-templates>
            <xsl:text>|===&#x0A;&#x0A;</xsl:text>
          </xsl:if>


          <!-- Codelisten typ 1,2 und 4 -->
          <xsl:if test="$codeDatentypen_1_2_4">
            <xsl:text>== Code-Typ 1, 2 und 4&#x0A;&#x0A;</xsl:text>
            
            <xsl:text>In der nachstehenden Tabelle werden die folgenden Informationen dargestellt:&#x0A;&#x0A;</xsl:text>

            <xsl:text>Code-Datentyp:: Alle in </xsl:text>
            <xsl:value-of select="$fachmodell-kurz"/>
            <xsl:text> definierten Code-Datentypen des Typs 1, 2 und 4 in alphabetischer Reihenfolge.&#x0A;</xsl:text>
            <xsl:text>Codeliste:: Der Name (kurz)footnote:[Weitere Informationen zu den Metadaten einer Codeliste sind im aktuellen Codelisten-Handbuch beschrieben.] der im jeweiligen Code-Datentyp genutzten Codeliste.&#x0A;</xsl:text>
            <xsl:text>Version:: Die Version der im jeweiligen Code-Datentyp genutzten Codeliste (Attribut listVersionID).&#x0A;</xsl:text>
            <xsl:text>Typ:: Art der Codelistennutzung, wie im Codelisten-Handbuch beschrieben.&#x0A;&#x0A;</xsl:text>

            <xsl:text>[id=code-uebersichtstabelle-typ124]&#x0A;</xsl:text>
            <xsl:text>[cols="46%,41%,9%,4%"]&#x0A;</xsl:text>
            <xsl:text>|===&#x0A;</xsl:text>
            <xsl:text>|Code-Datentyp|Codeliste|Version|Typ&#x0A;&#x0A;</xsl:text>

            <xsl:apply-templates select="$codeDatentypen_1_2_4" mode="lite:code-datentyp-124-codelisten">
              <xsl:sort select="@name"/>
            </xsl:apply-templates>
            
            <xsl:text>|===&#x0A;&#x0A;</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
      <xsl:with-param name="method">text</xsl:with-param>
      <xsl:with-param name="content" select="$content"/>
    </xsl:call-template>

  </xsl:template>

  <!-- Erzeuge den gewünschten Content -->
  <xsl:template match="codeDatentyp" mode="lite:code-datentyp-124-codelisten">
    <xsl:variable name="codeliste" as="element()?">
      <xsl:sequence select="lite:genutzte-cl-oder-vcl(.)"/>
    </xsl:variable>
    <xsl:variable name="version" as="xs:string?" select="@version"/>
    
    <xsl:choose>
      <xsl:when test="empty($codeliste)">
        <!-- Typ 2, 4 -->
        
        <!-- Name des Code-Datentyps -->
        
        <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat('|xref:#', lite:docbook-id(.), '[', lite:name-with-name-praefix-and-suffix(.), ']')"/>
        <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
        <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat('|xref:', lite:baustein-pfad(.), '.adoc[', lite:name-with-name-praefix-and-suffix(.), ']')"/>
        <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
        
        
        <!-- Name der Codeliste (bei Typ 2, 4 nicht vorhanden) -->
        <xsl:value-of select="'| --'"/>
        
        <!-- Version der Codeliste -->
        <xsl:text>|</xsl:text>
        <xsl:choose>
              <xsl:when test="empty($version)">
                <!-- bei Typ 4 nicht vorhanden -->
                <xsl:value-of select="'--'"/>
              </xsl:when>
              <xsl:otherwise>
                <!-- Typ 2 -->
                <xsl:value-of select="replace(@version,'(.)',concat('$1',xgen:unescaped-xml('&amp;'), '#x200B;'))"/>
              </xsl:otherwise>
            </xsl:choose>
        
        <!-- Anbindungstyp -->
        <xsl:text>|</xsl:text>
        <xsl:sequence select="lite:code-typ(., $codeliste, codesSchemavalidiert/text())"/>
        <xsl:text>&#x0A;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <!-- Typ 1 -->
        
        <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat('|xref:#', lite:docbook-id(.), '[', lite:name-with-name-praefix-and-suffix(.), ']')"/>
        <xsl:value-of select="concat('|xref:#', replace(concat('tabelle.', @kennung), ':', '.'), '[', lite:codeliste-nameLang($codeliste), ']')"/>
        <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
        <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
        <xsl:value-of select="concat('|xref:', lite:baustein-pfad(.), '.adoc[',lite:name-with-name-praefix-and-suffix(.),']&#x0A;')"/>
        <xsl:value-of select="concat('|xref:anhang/codelisten/codelistenGesamt.adoc#', replace(concat('tabelle.', @kennung), ':', '.'), '[', lite:codeliste-nameLang($codeliste), ']')"/>
        <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
        
        <xsl:text>|</xsl:text> 
        <xsl:choose>
              <xsl:when test="empty($version)">
                <xsl:value-of select="'--'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="replace(@version,'(.)',concat('$1',xgen:unescaped-xml('&amp;'), '#x200B;'))"/>
              </xsl:otherwise>
            </xsl:choose>
        <xsl:text>|</xsl:text>
        <xsl:sequence select="lite:code-typ(., $codeliste, codesSchemavalidiert/text())"/>
        <xsl:text>&#x0A;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template match="codeDatentyp" mode="lite:code-datentyp-3-codelisten">
    
    <xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
    <xsl:value-of select="concat('|xref:#', lite:docbook-id(.), '[', lite:name-with-name-praefix-and-suffix(.), ']')"/>
    <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
    <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
    <xsl:value-of select="concat('|xref:', lite:baustein-pfad(.), '.adoc[', lite:name-with-name-praefix-and-suffix(.), ']')"/>
    <xsl:text>&#x0A;endif::[]&#x0A;</xsl:text>
    
    <xsl:value-of select="concat('|https://www.xrepository.de/details/',@kennung, '[', @kennung, ']&#x0A;')"/>
    
  </xsl:template>

</xsl:stylesheet>
