<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">
	
	
	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>**************************************************************************************************************************************</xd:p>
			<xd:p>Dieses Stylesheet stellt allgemein nutzbare Templates bereit.</xd:p>
			<xd:p>**************************************************************************************************************************************</xd:p>
		</xd:desc>
	</xd:doc>	
		
		
		

	<xd:doc scope="stylesheet">
		<xd:desc>
			<xd:p>**************************************************************************************************************************************</xd:p>
			<xd:p>(1) Verarbeitung der <xd:i>beschreibung</xd:i>-Elemente, in denen die Pfleger:in des Standards DocBook-basiert eine bestimmte Struktur (Nachricht, Datentyp, Eigenschaft, etc) dokumentiert hat.</xd:p>
			<xd:p>**************************************************************************************************************************************</xd:p>
		</xd:desc>
	</xd:doc>
  
  <xd:doc>
    <xd:desc>
      <xd:p>Verarbeitet Elemente, die Docbook-Elemente enthalten können.</xd:p>
      <xd:p>Betrifft momentan (1.2.0) Beschreibung (außer in Geschäftsregel)), Umsetzungshinweis und Rechtsgrundlage</xd:p>
    </xd:desc>
    <xd:param name="hatBlockinhalt">wenn wahr: Element befindet sich in einer Tabellenzelle mit Elementen, die AsciiDoc-Blöcke sind.</xd:param>
  </xd:doc>
  <xsl:template match="beschreibung|umsetzungshinweis|rechtsgrundlage" mode="lite:dokumentation.FliesstextUndDocBookType">
    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>
    <xsl:if test="self::umsetzungshinweis">
      <xsl:value-of select="if ($hatBlockinhalt) then '[small]#' else ''"/>
      <xsl:text>*Umsetzungshinweise:*</xsl:text>
      <xsl:value-of select="if ($hatBlockinhalt) then '#&#x0A;&#x0A;' else '&#x0A;&#x0A;'"/>
    </xsl:if>
    
    <!-- Dokbook-Inhalte werden verarbeitet, soweit dafür Templates angelegt wurden. -->
    <xsl:variable name="ergebnis">
      <xsl:apply-templates select="@*|node()"/>
    </xsl:variable>
    <!-- Anschließend wird geprüft, ob noch Elemente auftreten, die durch kein Template abgedeckt sind. -->
    <xsl:if test="$ergebnis/element()">
      <!-- Wen ja, werden diese in einem Warnhinweis aufgelistet -->
      <xsl:value-of select="concat('#Achtung: Inhalt enthält unverarbeitete Elemente: ', 
        string-join(distinct-values($ergebnis/element()/local-name()), ', '), '#&#x0A;&#x0A;')"/>
    </xsl:if>
    	  <xsl:value-of select="if ($hatBlockinhalt) then '[small]#' else ''"/>
    <xsl:value-of select="$ergebnis"/>
    	  <xsl:value-of select="if ($hatBlockinhalt) then '#' else ''"/>
    <xsl:text>&#x0A;</xsl:text>
  </xsl:template>
  
	
	<xd:doc>
		<xd:desc>
			<xd:p>Dieses Template verarbeitet ein <xd:i>beschreibung</xd:i>-Element.</xd:p>
			<xd:p>Falls das Beschreibung-Element noch unberücksichtigte (Docbook-)Unterelemente enthält, wird vorerst eine Warnung ausgegeben und der Inhalt als Text ausgegeben. Formatierungen gehen dabei verloren.</xd:p>
		  <xd:p>
		    Später soll entschieden werden, wie dieser Fall korrekt behandelt wird.
		  </xd:p>
		</xd:desc>
	</xd:doc>
<!--  <xsl:template match="beschreibung" mode="lite:dokumentation.beschreibung">
    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>
	  <!-\- beschreibung wird soweit wie vorgesehen verarbeitet. -\->
	  <xsl:variable name="ergebnis">
	    <xsl:apply-templates select="node()"/>
	  </xsl:variable>
	  <!-\- Anschließend wird geprüft, ob noch Elemente auftreten, die durch kein Template abgedeckt sind. -\->
	  <xsl:if test="$ergebnis/element()">
	    <xsl:value-of select="concat('#Achtung: Beschreibung enthält unverarbeitete Elemente: ', 
	      string-join($ergebnis/element()/local-name(), ', '), '#&#x0A;&#x0A;')"/>
	  </xsl:if>
    <xsl:if test="$hatBlockinhalt">[small]#</xsl:if>
	  <xsl:value-of select="$ergebnis"/>
<!-\-	  <xsl:value-of select="normalize-space($ergebnis)"/>-\->
    <xsl:if test="$hatBlockinhalt">#</xsl:if>
	  <xsl:text>&#x0A;&#x0A;</xsl:text>
	</xsl:template> -->
  
  <xd:doc>
    <xd:desc>Beschreibungen und Umsetzungshinweise werden i.d.R. innerhalb von db:para-Elementen angegeben. Dieses Template verarbeitet den Inhalt dieser Elemente.</xd:desc>
  </xd:doc>
  <xsl:template match="db:para">
<!--    <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>-->
<!--    <xsl:value-of select="if ($hatBlockinhalt) then '[small]#' else ''"/>-->
    <xsl:apply-templates select="node()"/>
<!--    <xsl:value-of select="if ($hatBlockinhalt) then '# ' else ''"/>-->
    <xsl:text>&#x0A;&#x0A;</xsl:text>
  </xsl:template>
  
  
  <xd:doc>
    <xd:desc>Fettgedruckter Code-Text</xd:desc>
  </xd:doc>
  <xsl:template match="db:emphasis[@role='codebf']">
    <xsl:text>`*</xsl:text>
    <xsl:apply-templates select="node()"/>
    <xsl:text>*`</xsl:text>
  </xsl:template>
  
  
  <xd:doc>
    <xd:desc>Kursivdruck</xd:desc>
  </xd:doc>
  <xsl:template match="db:emphasis|db:emphasis[@role='italics']">
    <xsl:text>_</xsl:text>
    <xsl:apply-templates select="node()"/>
    <xsl:text>_</xsl:text>
  </xsl:template>
  
  <xd:doc>
    <xd:desc>Zitat</xd:desc>
  </xd:doc>
  <xsl:template match="db:quote">
    <xsl:text>"`</xsl:text>
    <xsl:apply-templates select="node()"/>
    <xsl:text>`"</xsl:text>
  </xsl:template>
  
  <xd:doc>
    <xd:desc>Entity, wird vorerst nicht aufgelöst, sondern nur farbig hervorgehoben.</xd:desc>
  </xd:doc>
  <xsl:template match="db:entity">
    <xsl:text>[red]#</xsl:text>
    <xsl:apply-templates select="node()"/>
    <xsl:text>#</xsl:text>
  </xsl:template>
  
  <xd:doc>
    <xd:desc>Externer Link</xd:desc>
  </xd:doc>
  <xsl:template match="db:link">
    <!-- Problem: es werden unter Umständen Links ohne Schema (http, https, ftp, irc, mailto) verwendet. Der Link wird dann nicht automatisch erkannt. Eigentlich sollte dann das Link-Makro link:<target>[<attrlist>] funktionieren. Es wird dann aber ein Link zu einer lokalen Datei erzeugt. 
    Daher werden nur Links verarbeitet, die mit einem der genannten Schemata beginnen -->
    <xsl:choose>
      <xsl:when test="matches(@xlink:href, '^(https|http|ftp|irc|mailto):.+')">
        <xsl:value-of select="concat(@xlink:href, '[', text(), ']')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="@xlink:href"/>
        <xsl:text> ##Achtung: Linkadressen müssen mit einem Schema (https, http, ftp, irc oder mailto) beginnen, um einen funktionsfähigen Link zu erzeugen.##</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xd:doc>
    <xd:desc>Dieses Template verarbeitet Querverweise auf manuell erstellte und im src-Ordner abgelegte Spezifikationsteile, die in die Spezifikation eingebunden werden. Sie funktionieren nur, wenn das komplette Spezifikationsdokument samt selbst erstellter Komponenten erzeugt wird. Ansonsten wird nur der Inhalt des Attributs "linkend" als Linktext angezeigt, der Link hat keine Wirkung.</xd:desc>
  </xd:doc>
  <xsl:template match="db:xref">
    <!-- Beispiel: <db:xref linkend="spezifikation.bfj.prozessmodell.fachspezifische_DA.eFuehrungszeugnis" role="AS"/> -->
        
    <!-- Hinter den Punkten wird ein breitenloses Leerzeichen eingefügt, um die Trennung zu ermöglichen. -->
    <xsl:value-of select="concat('xref:#', @linkend,'[',replace(@linkend, '\.', '.&#x200B;'),']&#x0A;')"/>
    
    <!-- Falls eine besondere Behandlung (Hinweistext etc.) erwünscht ist, wenn der Link nicht ins Volldokument eingebunden ist: -->
    <!--<xsl:text>&#x0A;ifdef::volldokument[]&#x0A;</xsl:text>
    <xsl:value-of select="concat('xref:#', @linkend,'[]&#x0A;')"/>
    <xsl:text>endif::[]&#x0A;</xsl:text>
    <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
    <xsl:value-of select="concat('[green]#', @linkend,'#&#x0A;')"/>
    <xsl:text>endif::[]&#x0A;</xsl:text>-->
 
  </xsl:template>
  
  <xd:doc>
    <xd:desc>Aufzählungsliste</xd:desc>
    <xd:param name="inTabelle">Liste befindet sich in Eigenschaftentabelle (es wird dann ein Workaround für den adoc-Listenblock verwendet).</xd:param>
  </xd:doc>
  <xsl:template match="db:itemizedlist">
    <xsl:param name="inTabelle" as="xs:boolean" select="false()" required="no" tunnel="yes"/>
    <xsl:for-each select="db:listitem/db:para">
      <xsl:value-of select="if ($inTabelle = true()) then '&#x2022; ' else '* '"/>
      <xsl:apply-templates select="node()"/>
      <xsl:value-of select="if ($inTabelle = true()) then ' +&#x0A;' else '&#x0A;'"/>
    </xsl:for-each>
  </xsl:template>
  
  <!--  -->
  
  <xd:doc>
    <xd:desc>Tabelle.</xd:desc>
    <xd:param name="inTabelle">Tabelle befindet sich in Eigenschaftentabelle. Wird vorerst nicht angeboten. Wenn doch erwünscht, müssen in diesem Fall die |-Symbole bei den Blockbegrenzern und Zellenseparatoren durch Ausrufezeichenh ersetzt werden.</xd:param>
  </xd:doc>
  <xsl:template match="db:informaltable">
        <xsl:param name="inTabelle" as="xs:boolean" select="false()" required="no" tunnel="yes"/>
    <xsl:choose>
      <xsl:when test="$inTabelle=false()">
        <xsl:variable name="tabellenbreite" as="xs:double" select="sum(for $width in db:tgroup/db:colspec/@colwidth return number(substring-before($width, 'mm')))"/>
        
        <xsl:value-of select="concat('[cols=&quot;', 
          string-join(for $colwidth in db:tgroup/db:colspec/@colwidth return concat(round((number(substring-before($colwidth,'mm')) div $tabellenbreite)*100.0),'%'),','), 
          '&quot;]&#x0A;')"/>
        
        <xsl:text>|===&#x0A;</xsl:text>
        <xsl:value-of select="concat('|',string-join(db:tgroup/db:thead/db:row/db:entry, '|'),'&#x0A;&#x0A;')"/>
        <xsl:for-each select="db:tgroup/db:tbody/db:row">
          <xsl:value-of select="concat('|',string-join(db:entry, '|'), '&#x0A;')"/>
        </xsl:for-each>
        <xsl:text>|===&#x0A;&#x0A;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#x0A;&#x0A;##Docbook-Tabellen innerhalb von Eigenschaftentabellen werden von der Asciidoc-Generierung nicht unterstützt.##&#x0A;&#x0A;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
  <!-- 
    Ermittlung verwendeter Docbook-Elemente in Beschreibung:
    
  distinct-values(//beschreibung/db:para/element()/name())
  
  xmeld:
    
  <db:informaltable>
  <db:entity>
  <db:emphasis role="strong">
  
  db:property-ref - dargestellt wie codebf
  db:message-number - mit Verlinkung, obwohl in lite nicht erkennbar <db:message-number>Nachricht 1714</db:message-number>, Schriftart Standard, aber in Linkfarbe
  db:code-ref - <db:code-ref cl="urn:xoev-de:xmeld:codeliste:anmeldung.status">01</db:code-ref> mit Verlinkung, Schriftart codebf
  -->
	
	<xd:doc>
		<xd:desc>
			<xd:p>Entferne bei allen Attributen den Namespace-Präfix "<xd:i>db</xd:i>".</xd:p>
		  <xd:p>Achtung: Dieses Template wird für lite2adoc vorerst nicht benötigt.</xd:p>
		</xd:desc>
	</xd:doc>
	<xsl:template match="@db:*">
		<xsl:attribute name="{local-name()}">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Identity Template</xd:p>
		</xd:desc>
	  <xd:param name="hatBlockinhalt">wenn wahr: Element befindet sich in einer Tabellenzelle mit Elementen, die AsciiDoc-Blöcke sind.</xd:param>
	</xd:doc>
	<xsl:template match="@*|node()">
	  <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
  
  <!-- Templates, um überflüssigen Whitespace loszuwerden.
    TODO: sehr plump, kann das eleganter umgesetzt werden? -->
  <!-- ggf. hier  priority="1" setzen -->
  <xsl:template match="text()[position()=1][parent::beschreibung | parent::umsetzungshinweis]" priority="1">
    <xsl:value-of select="replace(., '^\s+', '')"/>
  </xsl:template>
  
  <xsl:template match="text()[following-sibling::db:para | following-sibling::db:informaltable]">
  </xsl:template>
	
	<xd:doc>
		<xd:desc>
			<xd:p>Erzeuge eine Tabelle mit Geschäftsregeln.</xd:p>
		</xd:desc>
	  <xd:param name="hatBlockinhalt">
	    <xd:p>Ist true, wenn die Tabelle für die Geschäftsregel als Block innerhalb der Eigenschaftentabelle erzeugt werden muss (verschachtelte Tabellen). Dann wird ein anderes Zeichen als Blockmarkierung und Zellenbegrenzung verwendet (default: ! statt |)</xd:p>
	  </xd:param>
	</xd:doc>
	<xsl:template match="nachricht | datentyp | globaleEigenschaftengruppe | globaleEigenschaft | eigenschaft | codeDatentyp | xsdSchema | paket" 
		mode="lite:dokumentation.geschaeftsregeln">
	  <xsl:param name="hatBlockinhalt" select="false()" as="xs:boolean" tunnel="yes"/>
	  
		<!-- Die Tabelle wird nur dann erzeugt, wenn es mindestens eine "geschaeftsregel" gibt. -->
		<xsl:if test="geschaeftsregel">
		  <!-- TODO: Überschriftenebene noch nicht berücksichtigt, muss ggf. als Parameter übergeben werden. -->
<!--		  <xsl:text>=== Geschäftsregeln&#x0A;</xsl:text>-->
		  <xsl:text>== Geschäftsregeln&#x0A;</xsl:text>
				
				<!--
				<xsl:comment>*** Umgang mit optionalen Kindelementen ('auswertungskontext', 'fachkontext') von Geschäftsregeln: KLÄREN! ***</xsl:comment>
				<xsl:call-template name="annotation.todo.xoevlite.developer">
					<xsl:with-param name="titel">Umgang mit optionalen Kindelementen von Geschäftsregeln: KLÄREN</xsl:with-param>
					<xsl:with-param name="beschreibung">Es ist unklar, wie mit den optionalen Kindelementen ('auswertungskontext', 'fachkontext') von Geschäftsregeln umgegangen werden soll. Dies muss geklärt werden.</xsl:with-param>
					<xsl:with-param name="url">https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/38#datentypen</xsl:with-param>
				</xsl:call-template>
				-->
		  
		  <xsl:value-of select="concat('[id=table.',lite:docbook-id(.),'.rules]&#x0A;')"/>
		  <xsl:text>[cols="13%,87%"]&#x0A;</xsl:text>

		  <xsl:value-of select="if ($hatBlockinhalt) then '!===&#x0A;!ID!Regel / XPath&#x0A;&#x0A;' else '|===&#x0A;|ID|Regel / XPath&#x0A;&#x0A;'"/>
		  
		  <!-- "zero width space (ZWSP)" zum Aufbrechen der Kennung, damit diese umgebrochen werden kann. -->
		  <xsl:variable name="zwsp" select="'&#x200B;'"/>
		  <xsl:for-each select="geschaeftsregel">
				<xsl:sort select="@kennung"/>
		    <xsl:value-of select="if ($hatBlockinhalt) then '.2+!' else '.2+|'"/>
		    <xsl:value-of select="replace(@kennung, '(.)', concat('$1', $zwsp))"/>
		    <xsl:value-of select="concat(if ($hatBlockinhalt) then '!' else '|',beschreibung)"/>
		    <!-- Beschreibung einer Geschäftsregel ist nur String, im Gegensatz zu Bausteinen und Eigenschaften. -->
<!--		    <xsl:value-of select="if ($hatBlockinhalt) then '!' else '|'"/>-->
<!--		    <xsl:apply-templates select="beschreibung" mode="lite:dokumentation.beschreibung"/>-->
		    <xsl:value-of select="concat(if ($hatBlockinhalt) then '!`*' else '|`*', spezifikation, '*`&#x0A;')"/>
			</xsl:for-each>
		  <xsl:value-of select="if ($hatBlockinhalt) then '!===&#x0A;&#x0A;' else '|===&#x0A;&#x0A;'"/>
		</xsl:if>
	</xsl:template>
	
	
  <xd:doc>
    <xd:desc>
      Erzeugt einen Block mit AciiDoc-Dokumentattributen für einzelne adoc-Dokumente. 
      Dieser ist notwendig, wenn nicht die komplette Spezifikation angezeigt wird, sondern nur ein Teildokument.
      Wichtig sind vor allem die an die Dokumentposition angepassten Pfadangaben für Querverweise und Grafikeinbindungen.
    </xd:desc>
  </xd:doc>
  <xsl:template match="*" mode="lite:dokumentation.adoc-header">
    <!--<xsl:variable name="level" select="count(ancestor-or-self::*[self::xoev-fachmodell|self::paket|self::xsdSchema])"/>
    -->
    <xsl:variable name="istPaket" select="self::xoev-fachmodell|self::paket|self::xsdSchema"/>
    <xsl:variable name="level">
      <xsl:choose>
        <xsl:when test="$istPaket">
          <xsl:value-of select="count(ancestor::*[self::xoev-fachmodell|self::paket|self::xsdSchema])"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="count(ancestor-or-self::*[self::xoev-fachmodell|self::paket|self::xsdSchema])"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dokumente-navigate-up" select="string-join(for $i in 1 to $level return '../', '')"/>
    
    <xsl:text>ifndef::volldokument[]&#x0A;</xsl:text>
    <xsl:text>:sectnums:&#x0A;</xsl:text>
    <xsl:text>:sectnumlevels: 5&#x0A;</xsl:text>
    <xsl:text>:partnums:&#x0A;</xsl:text>
    <xsl:text>:chapter-refsig: Kapitel&#x0A;</xsl:text>
    <xsl:text>:section-refsig: Abschnitt&#x0A;</xsl:text>
    <xsl:text>:xrefstyle: short&#x0A;</xsl:text>
    <xsl:text>:figure-caption: Abbildung&#x0A;</xsl:text>
    <xsl:text>:table-caption: Tabelle&#x0A;</xsl:text>
    <xsl:text>:icons: image&#x0A;</xsl:text>
    <xsl:text>:icontype: svg&#x0A;</xsl:text>
    <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>
    
    <!-- Falls das Dokument per include in ein anderes AsciiDoc-Dokument eingebettet ist,
	  wird der dort definierte relative Pfad zum dokumente-Verzeichnis angewendet.
	  Falls nicht, wird der Pfad hier definiert. -->
    <xsl:text>ifndef::relfileprefix[]&#x0A;</xsl:text>
    <xsl:value-of select="concat(':relfileprefix: ',if (string-length($dokumente-navigate-up) = 0) then './' else $dokumente-navigate-up, '&#x0A;')"/> 
    <!-- Der relative Pfad zum dokumente-Verzeichnis wird anschließend auch als Ausgangspunkt 
	    für Zeichnung- und Icondateien verwendet. -->
    <xsl:text>:imagesdir: {relfileprefix}../zeichnungen&#x0A;</xsl:text>
    <xsl:text>:iconsdir: {relfileprefix}../../../xgen-applications/xoev-lite/images/kosit/icons&#x0A;&#x0A;</xsl:text>
    <xsl:text>endif::[]&#x0A;&#x0A;</xsl:text>
  </xsl:template>
	
	
		  <xd:p>***************************************************************************************************</xd:p>
		  <xd:p> Templates für die Erzeugung von ToDo-Anntotationen:</xd:p>
		  <xd:p>  - ein Template für Nutzer:innen von XÖV lite Standards</xd:p>
		  <xd:p>  - ein Template für Entwickler:innen von XÖV lite</xd:p>
  <xd:p>*********************************************************************************************************</xd:p>
  
  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template erzeugt eine <xd:i>ToDo</xd:i>-Annotation für Pfleger:innen von XÖV lite Standards.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template name="annotation.todo.xoevlite.user">
    <annotation role="todo">
      <info>
        <title>Dokumentation fehlt!</title>
      </info>
      <para>Dieses ToDo wurde automatisch generiert.</para>
    </annotation>
  </xsl:template>
  
  <xd:doc>
    <xd:desc>
      <xd:p>Dieses Template erzeugt eine <xd:i>ToDo</xd:i>-Annotation für eine XÖV lite Entwickler:in.</xd:p>
    </xd:desc>
    <xd:param name="titel">Text für die Titelzeile des ToDo, die in rot im PDF erscheint</xd:param>
    <xd:param name="beschreibung">Mehr oder weniger umfangreiche Beschreibung des ToDo</xd:param>
    <xd:param name="url">Optionale URL-Angabe (üblicherweise eines GitLab-Tickets, z. B.: "<xd:i><xd:b>https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/16#note_204329</xd:b></xd:i>" – es kann aber auch ein "normaler" Link sein)</xd:param>
  </xd:doc>
  <xsl:template name="annotation.todo.xoevlite.developer">
    <xsl:param name="titel" as="xs:string" required="yes"/>
    <xsl:param name="beschreibung" as="xs:string" required="yes"/>
    <xsl:param name="url" as="xs:string?"/>
    
    <annotation role="todo">
      <info>
        <title>
          <xsl:value-of select="$titel"/>
          <xsl:text>       (*** Entwicklung ***)</xsl:text>
        </title>
      </info>
      <para>
        <xsl:value-of select="$beschreibung"/>
      </para>
      <xsl:if test="$url">
        <para>
          <xsl:text>Siehe auch: </xsl:text>
          <!-- Wir benötigen die letzte Komponente des Pfades ("document entry") um zu erkennen, ob ein GitLab-Ticket vorliegt. -->
          <xsl:variable name="documentEntry" select="tokenize($url,'/')[last()]"/>
          <xsl:choose>	
            <xsl:when test="contains($documentEntry, '#') or $documentEntry castable as xs:integer">
              <!-- GitLab-Ticket: Wir holen uns die Ticketnummer und (falls vorhanden) die Positionsangabe und bauen den Link -->
              <link xlink:href="{$url}">
                <xsl:text>GitLab-Ticket </xsl:text>
                <xsl:value-of select="tokenize($documentEntry,'#')[1]"/>
                <xsl:value-of select="if (tokenize($documentEntry,'#')[2]) then concat(' (', tokenize($documentEntry,'#')[2], ')') else ''"/>
              </link>
            </xsl:when>
            <xsl:otherwise>
              <!-- Kein GitLab-Ticket: Erzeuge "normalen" Link -->
              <link>
                <xsl:value-of select="$url"/>
              </link>
            </xsl:otherwise>
          </xsl:choose>
        </para>
      </xsl:if>
    </annotation>
  </xsl:template>
</xsl:stylesheet>
