<?xml version="1.0" encoding="UTF-8"?>

<!-- Version 1.2.0 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xsl lite gc xoev-cl-2 xoev-cl-4 lite-bib lite-fm xgen xd log">
  
<!-- 
    SVG-Erzeugung kann bei Bedarf/nach Wunsch deaktiviert werden
    TODO: ggf. einen Parameter einrichten, der via XGenerator geschaltet werden kann
-->
<xsl:param name="generiere-svg" as="xs:boolean" select="false()"/>

<!-- Allgemeine Templates -->   
<xsl:include href="lite2adoc.uebersetzungsanweisungen.common-templates.xsl"/>

<!-- Hauptteil (Paketstruktur) -->
<xsl:include href="lite2adoc.paket_abschnitt_paketstruktur.xsl"/> 
<xsl:include href="lite2adoc.baustein_in_paketstruktur.xsl"/>
<xsl:include href="lite2adoc.baustein_eigenschaftentabelle.xsl"/>
<xsl:include href="lite2adoc.codeDatentyp_abschnitte_paketstruktur.xsl"/>

<!-- Anhang (bei Nachrichten auch pro Schema) -->
<xsl:include href="lite2adoc.nachrichten_uebersichtstabellen_paketstrukturUndAppendix.xsl"/>
<xsl:include href="lite2adoc.codeDatentypen_uebersichtstabellen_appendix.xsl"/>
<xsl:include href="lite2adoc.codelisten_uebersichtstabellenUndAbschnitte_appendix.xsl"/>
<xsl:include href="lite2adoc.externeModelle_uebersichtstabelle_appendix.xsl"/>

<!-- Optional: Sammeldatei mit Codedatentyp-Abschnitten, nicht standardmäßig eingebunden -->
<xsl:include href="lite2adoc.codeDatentypen_abschnitteGesamt_appendix.xsl"/>


  <xd:doc>
    <xd:desc>
      <xd:p>In diesem Template werden alle lite2db-Transformationen aufgerufen.</xd:p>
      <xd:p>Einstiegspunkt ist immer der Dokumentknoten eines Fachmodells.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="/" mode="lite:default-lite2adoc">
    
    <!-- Infos zum Standard, zwischen Inhaltsverzeichnis und Inhalt -->
    <xsl:apply-templates select="." mode="lite:frontmatter"/>
        
    <!-- Einstiegspunkt in die Paketstruktur -->
    <xsl:apply-templates select="." mode="lite:paket-abschnitt-paketstruktur"/>
    
    <!-- Erzeugte Artefakte sind teils selbständig, teils in die Paketstruktur einzubinden -->
    <xsl:apply-templates select="." mode="lite:nachrichten-tabelle-entry"/>
    <xsl:apply-templates select="." mode="lite:codelistenuebersicht"/>
    <xsl:apply-templates select="." mode="lite:code-datentyp-codelisten"/>
    <xsl:apply-templates select="." mode="lite:externe-modelle-und-inhalte-entry"/>
    
    <!-- Optional: Sammeldatei mit Codedatentyp-Abschnitten, nicht standardmäßig eingebunden -->
    <xsl:apply-templates select="." mode="lite:abschnitt-alle-code-datentypen"/>
    
    <!-- Hinweis: folgendes apply-templates erzeugt einen Ordner dokumente/codeDatentypen-einzeln-lite2db8/ 
      mit Dateien für jeden Codedatentyp. Wird momentan nicht benötigt. Die Dateien werden stattdessen im entsprechenden 
    Ordner der Paketstruktur abgelegt. -->
<!--    <xsl:apply-templates select="." mode="lite:abschnitt-codedatentyp-entry"/>-->
    
    <!-- Hinweis: Das Stylesheet zur Generierung von Abschnitten für die Nutzung von Typen in Nachrichten 
    ist noch nicht fertig. Es wird ggf. zu einem späteren Zeitpunkt weiterimplementiert, siehe
    https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/46 -->
    <!--<xsl:apply-templates select="." mode="lite:nutzung-typen-in-nachrichten"/>-->

  </xsl:template>
  
  <xd:doc>
    <xd:desc>Erzeugt einen kurzen Abschnitt mit den wichtigsten Eckdaten zum Standard</xd:desc>
  </xd:doc>
  <xsl:template match="xoev-fachmodell" mode="lite:frontmatter">
    
    <xsl:variable name="frontmatter">
           <xsl:text>&#x0A;[colophon]&#x0A;= Metadaten und Konfiguration des Standards&#x0A;&#x0A;</xsl:text>
      <xsl:value-of select="concat(metadaten.standard/nameLang,'&#x0A;&#x0A;')"/>
      <xsl:value-of select="concat('Version ', metadaten.versionStandard/version,'&#x0A;&#x0A;')"/>
      <xsl:if test="konfiguration.xoev-fachmodell/fassungVom">
        <xsl:value-of select="concat('Fassung vom ', konfiguration.xoev-fachmodell/fassungVom,'&#x0A;&#x0A;')"/>
      </xsl:if>
      <!-- format-date kann nicht verwendet werden, da das Element Freitext enthält -->
<!--      <xsl:value-of select="concat('Fassung vom ', format-date(konfiguration.xoev-fachmodell/fassungVom,'[D,2].[M,2].[Y]'),'&#x0A;&#x0A;')"/>-->
    </xsl:variable>
    <xsl:variable name="frontmatter-directory" select="'dokumente/frontmatter.adoc'" as="xs:string"/>
    
    <xsl:call-template name="xgen:result-document">
      <xsl:with-param name="local-path" select="xs:anyURI($frontmatter-directory)"/>
      <xsl:with-param name="method">text</xsl:with-param>
      <xsl:with-param name="content" select="$frontmatter"/>
    </xsl:call-template>
 </xsl:template>
  

<!-- ### Einstieg in die Transformation -->

  <xd:doc scope="component">
    <xd:desc><xd:p>Dieses Template bestimmt welcher Inhalt in einer Content Datei
      der Paketstruktur erzeugt wird. Jedem Elementtyp kann mit @mode Attribut 
      ein bestimmtes Template zugeordnet werden.</xd:p>
      <xd:p>Wenn bei einem Element der Paketstruktur kein Template zugeordnet ist 
        wird eine dummy-section erzeugt.</xd:p>
    </xd:desc>
  </xd:doc>
  <!-- Element Node als Einstiegspunkt für alle lite2db-Transformationen 
	die in lite:paket-abschnitt-paketstruktur enthalten sein sollen-->
  <xsl:template match="*" mode="lite:content-paketstruktur">
    <xsl:choose>
      <!-- templates die Daten zur Paketstruktur erzeugen werden
		     hier eingesetzt:
		   <xsl:when test="self::element">
		      <xsl:apply-templates select="." mode="lite:content-from-element"/>
		   </xsl:when>
		-->
      <xsl:when test="self::codeDatentyp">
        <!-- template in codeDatentyp_abschnitte_paketstruktur.xsl -->
        <xsl:apply-templates select="." mode="lite:abschnitt-codedatentyp-content"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat('= ', @name,'&#x0A;&#x0A;')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  
</xsl:stylesheet>
