<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:db="http://docbook.org/ns/docbook" 
	xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" 
	xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" 
	xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" 
	xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" 
	xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" 
	xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" 
	xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" 
	xmlns="http://docbook.org/ns/docbook" 
	xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" 
	version="2.0" 
	exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">
   
  
   <!-- Hinweis: Dieses Stylesheet zur Generierung von Abschnitten für die Nutzung von Typen in Nachrichten 
        ist noch nicht fertig. Es wird ggf. zu einem späteren Zeitpunkt weiterimplementiert, siehe
        https://projekte.kosit.org/xoev/lite-projekte/lite-dokumentation/-/issues/46 -->
	
	<!-- Einstiegspunkt für die Generierung -->
   <xsl:template match="/" mode="lite:nutzung-typen-in-nachrichten">
      
      <xsl:variable name="Nachricht-typ-zuordnung">
         <messages-with-types>
            <xsl:for-each select="//nachricht">
               <message name="{@name}" xml:id="{generate-id()}">
                  <xsl:sequence select="lite:get-datatypes(.)"/>
               </message>
            </xsl:for-each>
         </messages-with-types>
      </xsl:variable>
      
      <xsl:apply-templates select="//datentyp[not(@draft = 'true')]" mode="lite:alle-typen">
         <xsl:with-param name="Nachricht-typ" select="$Nachricht-typ-zuordnung"/>
         
      </xsl:apply-templates>
	</xsl:template>
	
	
   <!-- Erzeuge Datei-->
   <xsl:template match="//datentyp[not(@draft = 'true')][not(preceding::datentyp/@name = current()/@name)]" mode="lite:alle-typen">
      <xsl:param name="Nachricht-typ"/>
      <!-- Diese Variable verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
      <xsl:variable name="document-directory" select="'dokumente/anhang/verwendung/complexTypes'" as="xs:string"/>
      <xsl:variable name="target-document-directory" select="concat($document-directory, '/', @name, '_list.xml')" as="xs:string"/>
      
      <!-- Diese Variable enthält den Content einer zu erzeugenden Datei. -->
      
      
      <xsl:variable name="content">
         <section version="5">
            <title>Nutzung des Datentyps <xsl:value-of select="@name"/></title>
            <xsl:if test="$Nachricht-typ//message[type/@name =current()/@name]">
               <para>
                  <xsl:text>Dieser Typ kann in den folgenden Nachrichten übermittelt werden: </xsl:text>
                  <xsl:apply-templates select="$Nachricht-typ/messages-with-types" mode="lite:nutzende-nachrichten">
                     <xsl:with-param name="datentypName" select="@name"/>
                  </xsl:apply-templates>
               </para>
            </xsl:if>
            <xsl:if test="$Nachricht-typ//message[type/@name =current()/@name]">
               <para>Von diesem Typ leiten ab:</para>
            </xsl:if>
         </section>
         
      </xsl:variable>
      
      <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:call-template name="lite:write-file-return-log">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path" select="xs:anyURI($target-document-directory)"/>
      </xsl:call-template>
   </xsl:template>

   
   
   
	<!-- Erzeuge den gewünschten Content -->
   <xsl:template match="nachricht" mode="lite:nutzende-nachrichten">
      <xsl:param name="datentypName"/>
      <xsl:if test="exists(.//eigenschaft[ends-with(@typ,$datentypName)])">
         <link linkend="{@name}"><xsl:value-of select="@name"/></link>
      </xsl:if>
   </xsl:template>
	
</xsl:stylesheet>
