<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook" xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2" xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4" xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0" xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0" xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns="http://docbook.org/ns/docbook" xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0" version="2.0" exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib">


  <!-- Einbindung von lite2db-Transformationen aus lokalem xsl-Verzeichnis -->
  <!-- Includes werden hier eingebunden, da dann der direkte Zusammenhang mit 
	     den nachfolgenden Transformationen unmittelbar ersichtlich ist.
	     Außerdem erfolgt die Einbindung einer weiteren Funktionalität dadurch nur in diesem 
	     Stylesheet.
	-->
  <xd:doc scope="stylesheet">
    <xd:desc>
      <xd:p>Alle lite2db-Transformationen werden in externe Dateien ausgelagert.</xd:p>
      <xd:p>Diese externen Dateien werden mit include in dieses stylesheet integriert.</xd:p>
    </xd:desc>
  </xd:doc>
  <!-- 1) An dieser Stelle sind die durch Feature Branches erstellten Stylesheets zu inkludieren -->
  <xsl:include href="lite2db.uebersetzungsanweisungen.common-templates.xsl"/>
  <xsl:include href="lite2db.baustein_in_paketstruktur.xsl"/>
  <xsl:include href="lite2db.baustein_eigenschaftentabelle.xsl"/>
  <xsl:include href="lite2db.nachrichten_uebersichtstabellen_paketstrukturUndAppendix.xsl"/>
  <xsl:include href="lite2db.externeModelle_uebersichtstabelle_appendix.xsl"/>
  <xsl:include href="lite2db.codeDatentyp_abschnitte_paketstruktur.xsl"/>
  <xsl:include href="lite2db.paket_abschnitt_paketstruktur.xsl"/>

  <xsl:include href="lite2db.codeDatentypen_uebersichtstabellen_appendix.xsl"/>

  <xsl:include href="lite2db.codelisten_uebersichtstabellenUndAbschnitte_appendix.xsl"/>
  <xsl:include href="lite2db.codeDatentypen_abschnitteGesamt_appendix.xsl"/>
  <xsl:include href="lite2db.baustein_nutzungDatentyp.xsl"/>
  <xd:doc>
    <xd:desc>
      <xd:p>In diesem Template werden alle lite2db-Transformationen aufgerufen.</xd:p>
      <xd:p>Einstiegspunkt ist immer der Dokumentknoten eines Fachmodells.</xd:p>
    </xd:desc>
  </xd:doc>
  <xsl:template match="/" mode="lite:default-lite2db">
    <!-- Hier sind die lite2db-Transformationen aufzunehmen, siehe auch (1) -->
    <xsl:apply-templates select="." mode="lite:code-datentyp-codelisten"/>
    <xsl:apply-templates select="." mode="lite:nachrichten-tabelle-entry"/>
    <xsl:apply-templates select="." mode="lite:externe-modelle-und-inhalte-entry"/>
    <xsl:apply-templates select="." mode="lite:paket-abschnitt-paketstruktur"/>
    <xsl:apply-templates select="." mode="lite:codelistenuebersicht"/>
    <xsl:apply-templates select="." mode="lite:abschnitt-alle-code-datentypen"/>
    <xsl:apply-templates select="." mode="lite:nutzung-datentyp"/>
  </xsl:template>

  <xd:doc scope="component">
    <xd:desc>
      <xd:p>Dieses Template bestimmt welcher Inhalt in einer Content Datei der Paketstruktur erzeugt wird. Jedem Elementtyp kann mit @mode Attribut ein bestimmtes Template zugeordnet werden.</xd:p>
      <xd:p>Wenn bei einem Element der Paketstruktur kein Template zugeordnet ist wird eine dummy-section erzeugt.</xd:p>
    </xd:desc>
  </xd:doc>
  <!-- Element Node als Einstiegspunkt für alle lite2db-Transformationen 
	die in lite:paket-abschnitt-paketstruktur enthalten sein sollen-->
  <xsl:template match="*" mode="lite:content-paketstruktur">
    <xsl:choose>
      <!-- templates die Daten zur Paketstruktur erzeugen werden
		     hier eingesetzt:
		   <xsl:when test="self::element">
		      <xsl:apply-templates select="." mode="lite:content-from-element"/>
		   </xsl:when>
		-->
      <xsl:when test="self::codeDatentyp">
        <!-- Template befindet sich in Datei codeDatentyp_abschnitte_paketstruktur.xsl -->
        <xsl:apply-templates select="." mode="lite:abschnitt-codedatentyp-content"/>
      </xsl:when>
      <xsl:otherwise>
        <db:section version="5">
          <db:title>
            <xsl:value-of select="@name"/>
          </db:title>
          <para/>
        </db:section>
      </xsl:otherwise>
    </xsl:choose>


  </xsl:template>
</xsl:stylesheet>
