<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:db="http://docbook.org/ns/docbook"
   xmlns:gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/"
   xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log"
   xmlns:xoev-cl-2="http://xoev.de/schemata/genericode/2"
   xmlns:xoev-cl-4="http://xoev.de/schemata/genericode/4"
   xmlns:lite="urn:xoev-de:kosit:xoev:lite:transformation_1.2.0"
   xmlns:lite-bib="urn:xoev-de:kosit:xoev:lite:schema:bibliothek_1.2.0"
   xmlns:lite-fm="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0"
   xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
   xmlns="http://docbook.org/ns/docbook" version="2.0"
   exclude-result-prefixes="xgen xsl xs db gc log xoev-cl-2 xoev-cl-4 lite lite-fm lite-bib"
   xpath-default-namespace="urn:xoev-de:kosit:xoev:lite:schema:fachmodell_1.2.0">


   <xsl:variable name="max-tiefe-klassendiagramm" select="10" as="xs:integer"/>
  
  <!-- Standardausrichtung von links nach rechts -->
   <xsl:variable name="plantuml-left-to-right" select="true()" as="xs:boolean"/>

   <!-- Einstiegspunkt für die Generierung -->
   <xsl:template match="/" mode="lite:klassendiagramm-entry">

      <!-- PlantUML-Diagramme für Nachrichten -->
      <xsl:apply-templates select="//nachricht[not(@draft = 'true')]" mode="lite:klassendiagramm">
        <!-- Parameter behandelte-klassen wird zur Zeit nicht benötigt, kann ggf. zur Kontrolle von Rekursionen dienen. -->
         <xsl:with-param name="behandelte-klassen" as="xs:string*" tunnel="yes"/>
        <xsl:with-param name="unterverzeichnis" select="'nachrichten'"/>
      </xsl:apply-templates>
     
     <!-- PlantUML-Diagramme für Datentypen, die jeweils in einem Schema enthalten sind -->
     <xsl:apply-templates select="//xsdSchema[not(@draft = 'true')]" mode="lite:klassendiagramm"/>
   </xsl:template>
  
  <!-- Legt Klassendiagramme für Bausteine eines Schemas in einem Ordner "schema-[Schemaname]" an -->
  <xsl:template match="xsdSchema" mode="lite:klassendiagramm">
    <xsl:variable name="schemadir" select="concat('schema-',@name)"/>
    <xsl:apply-templates select=".//*[self::datentyp|self::globaleEigenschaft|self::globaleEigenschaftengruppe][not(@draft = 'true')][lite:ist-klasse(.)]" mode="lite:klassendiagramm">
      <xsl:with-param name="behandelte-klassen" as="xs:string*" tunnel="yes"/>
       <xsl:with-param name="unterverzeichnis" select="$schemadir"/>
    </xsl:apply-templates>
  </xsl:template>


   <!-- Erzeuge Datei-->
  <xsl:template match="nachricht|datentyp|globaleEigenschaft|globaleEigenschaftengruppe" mode="lite:klassendiagramm">
      <xsl:param name="behandelte-klassen" as="xs:string*" tunnel="yes"/>
     <xsl:param name="unterverzeichnis" as="xs:string" required="yes"/>
      <!-- Diese Variablen verweisen auf den Ordner in dem ein Datei gespeichert werden soll -->
      <xsl:variable name="document-directory" select="concat($unterverzeichnis,'/')" as="xs:string"/>
      <xsl:variable name="target-document-directory" select="$document-directory" as="xs:string"/>

      <!-- Schritt 1: Hilfsstruktur erzeugen -->
      <!-- Sammlung der auszugebenden Klassen und Relationen als XML-Elemente in einer Variable -->
      <xsl:variable name="klassendiagramm-elemente">
         <xsl:apply-templates select="." mode="lite:klassendiagramm-sammlung-class">
            <xsl:with-param name="tiefe" select="0" tunnel="yes"/>
            <xsl:with-param name="behandelte-klassen" as="xs:string*" tunnel="yes"/>
         </xsl:apply-templates>
      </xsl:variable>

      <!-- Schritt 2: PlantUML-Elemente erzeugen -->
      <!-- Weiterverarbeitung der XML-Elemente zu PlantUML -->
      <xsl:variable name="klassendiagramm-plantuml">
         <!-- Die Klassen und danach die Relationen werden zu PlantUML-Text verarbeitet, wobei anhand identifizierender Attribute Duplikate ausgefiltert werden. -->
         
         <xsl:for-each select="$klassendiagramm-elemente/*:klasse[not(@name-oder-id = preceding-sibling::*:klasse/@name-oder-id)]">
            <xsl:apply-templates
               select="."
               mode="lite:klassendiagramm-plantuml"/>
         </xsl:for-each>

         <xsl:for-each select="$klassendiagramm-elemente/*:relation[not(@relation-id = preceding-sibling::*:relation/@relation-id)]">
            <xsl:apply-templates
               select="."
               mode="lite:klassendiagramm-plantuml"/>
         </xsl:for-each>
         
      </xsl:variable>

      <!-- Schritt 3: PlantUML-Dateiinhalt erzeugen -->
      <!-- Hier werden die PlantUML-Elemente zu einer kompletten PlantUML-Struktur zusammengesetzt,
      die anschließend gespeichert werden kann. -->
      <xsl:variable name="content">
        <xsl:value-of select="concat('@startuml ',@name,'&#x0A;')"/>
        <!-- Wenn Punkte bspw. in Klassennamen erlaubt sein sollen: -->
        <xsl:text>set namespaceSeparator none&#x0A;</xsl:text>
        <!-- Darstellung von links nach rechts? -->
        <xsl:value-of select="if ($plantuml-left-to-right = true()) then 'left to right direction&#x0A;' else 'top to bottom direction&#x0A;'"/>
        <xsl:text>hide empty members&#x0A;</xsl:text>
        <xsl:text>hide circle&#x0A;</xsl:text>
        <xsl:text>skinparam linetype ortho&#x0A;</xsl:text>

         <xsl:value-of select="$klassendiagramm-plantuml"/>

         <xsl:text>@enduml</xsl:text>
      </xsl:variable>

      <!-- Schritt 4: Dateierzeugung -->
      <!-- Hier wird das Template zur Dateierzeugung aufgerufen -->
      <xsl:call-template name="lite:write-textfile-return-log">
         <xsl:with-param name="content" select="$content"/>
         <xsl:with-param name="local-path"
            select="xs:anyURI(concat($target-document-directory, 'klassendiagramm.', @name, '.plantuml'))"
         />
      </xsl:call-template>

   </xsl:template>


   <!-- Eine Eigenschaft ist als Klasse darzustellen, wenn ihr Datentyp komplex ist, d.h. wiederum Eigenschaften oder Eigenschaftengruppen enthält -->
   
   <xsl:function name="lite:ist-klasse" as="xs:boolean">
      <xsl:param name="element" as="element()"/>
      <xsl:variable name="typelement" select="lite:resolve($element/@typ, $element, false())"/>
      <xsl:variable name="referenzelement"
         select="lite:resolve($element/@referenz, $element, true())"/>
      <xsl:sequence select="
         boolean(
         $typelement/eigenschaft[not(@xsdAttribute = 'true')] or
         $typelement/eigenschaftengruppe or
         $element/name() = 'eigenschaftengruppe' or
         $referenzelement/name() = 'globaleEigenschaft' or
         $referenzelement/name() = 'globaleEigenschaftengruppe' or
         $element/eigenschaft or
         $element/eigenschaftengruppe)"/>
   </xsl:function>
   

   <!-- ############## Templates zur Sammlung der Diagrammbestandteile als Elemente ############### -->

   
   <xsl:template
      match="nachricht | datentyp | eigenschaft | eigenschaftengruppe | globaleEigenschaft | globaleEigenschaftengruppe"
      mode="lite:klassendiagramm-sammlung-class">
      <xsl:param name="tiefe" tunnel="yes" as="xs:integer"/>
      <xsl:variable name="current-id" select="generate-id(.)"/>

<!-- TODO: eventuell kann man hier sammeln, welche Elemente schon behandelt wurden und diese in der Weiterverarbeitung ignorieren. Funktioniert bisher nicht wie gewünscht, sondern die Liste der behandelten Klassen wird bei jedem Geschwisterelement neu angesetzt. -->
      <xsl:if test="$tiefe &lt;= $max-tiefe-klassendiagramm">

         <xsl:variable name="klassen" select="eigenschaft[lite:ist-klasse(.)] | eigenschaftengruppe"/>

         <!-- Anonyme Eigenschaften mit Attribut @name werden NICHT wie Eigenschaften mit Datentypen behandelt. 
            Sie erhalten statt einem Datentypnamen eine ID, der Name wird als Name an der Relation verwendet. 
         Das gleiche gilt für anonyme Eigenschaftengruppen. -->
        <xsl:variable name="anonyme-eigenschaft"
          select="(self::eigenschaft or self::eigenschaftengruppe) and (eigenschaft or eigenschaftengruppe)"/>
        

         <!-- Klasse für Nachricht oder Datentyp selbst -->
    
         <klasse 
            name-oder-id="{if ($anonyme-eigenschaft) then generate-id() else if (@name) then @name else generate-id()}" 
            klasse-id="{$current-id}" 
            alias="{if ($anonyme-eigenschaft) then '&quot;//anonymer Datentyp//&quot; as ' else if (@name) then '' else '&quot;//unbenannt//&quot; as '}" 
            stereotyp="{if (@art) then concat(' &lt;&lt;', @art, '>>') else if (@gruppe.art) then concat(' &lt;&lt;', @gruppe.art, '>>') else ''}">
            <!-- Felder der Klasse für Eigenschaften mit nicht-komplexen Datentypen -->
            <!-- Zuerst alle Attribute, danach die anderen Kindelemente -->
           <xsl:apply-templates select="eigenschaft[not(lite:ist-klasse(.))][@xsdAttribute = true()]" mode="lite:klassendiagramm-prepare"/>
           <xsl:apply-templates select="eigenschaft[not(lite:ist-klasse(.))][not(@xsdAttribute = true())]" mode="lite:klassendiagramm-prepare"/>
         </klasse>

         <!-- Relationen, die von der aktuellen Nachricht oder dem Datentyp ausgehen -->
         <xsl:variable name="parent-name" select="
               if ($anonyme-eigenschaft) then
                  generate-id()
               else
                  if (@name) then
                     @name
                  else
                     generate-id()"/>
        
         <!-- ggf. Vererbungsrelation -->
         <xsl:if test="@basistyp">
            <relation
               relation-id="{concat($parent-name, '|', @basistyp)}" 
               parent-name="{$parent-name}" 
               basistyp="{substring-after(@basistyp, ':')}" 
            />
         </xsl:if>

         <!-- ansonsten Relation zum Kindelement -->
         <xsl:for-each select="$klassen">
            <xsl:variable name="child-typ" select="
                  if (@typ) then
                     substring-after(@typ, ':')
                  else
                     if (@referenz) then
                        substring-after(@referenz, ':')
                     else
                        generate-id()"/>
            <xsl:variable name="child-name" select="
                  if (@name) then
                     @name
                  else
                     'unbenannt'"/>
          
            <!-- modifier: Art der Relation, z.B. Komposition, hier direkt als PlantUML-Symbol -->
            <relation 
               relation-id="{concat($parent-name, '|', $child-typ, '|', $child-name)}" 
               parent-name="{$parent-name}" 
               child-name="{$child-name}" 
               child-typ="{$child-typ}" 
               multiplizitaet="{(@multiplizitaet, 1)[1]}" 
               modifier="{if (self::eigenschaftengruppe) then '*' else ''}" 
            />
         </xsl:for-each>

         <!-- für untergeordnete komplexe Datentypen (rekursiv) -->
         <xsl:apply-templates select="$klassen" mode="lite:klassendiagramm-sammlung-class">
            <xsl:with-param name="tiefe" select="$tiefe + 1" tunnel="yes"/>
         </xsl:apply-templates>
      </xsl:if>
   </xsl:template>

<!-- Hilfselemente für Felder der Klassen -->
  
  <!-- Attribute (TODO: vereinfachen, bei Attributen ist nicht alles wie bei anderen Eigenschaften möglich) -->
  <xsl:template match="eigenschaft[not(lite:ist-klasse(.))][@xsdAttribute = true()]" mode="lite:klassendiagramm-prepare">
  <feld 
    name="{concat('@', @name)}" 
    default="{if (@defaultWert) then concat(' = ', @defaultWert) else ''}" 
    typ="{if (@basistyp) then concat(substring-after(@basistyp, ':'), if (@restriction=true()) then ' &lt;Einschränkung&gt;' else ' &lt;Erweiterung&gt;') else substring-after(@typ, ':')}" 
    multiplizitaet="{(@multiplizitaet, 1)[1]}"
  />
</xsl:template>
  
  <!-- Nichtattribute -->
  <xsl:template match="eigenschaft[not(lite:ist-klasse(.))][not(@xsdAttribute = true())]" mode="lite:klassendiagramm-prepare">
    <xsl:variable name="typangabe">
      <xsl:choose>
        <xsl:when test="@typ">
          <xsl:value-of select="substring-after(@typ, ':')"/>
        </xsl:when>
        <xsl:when test="@basistyp">
          <xsl:value-of select="concat(substring-after(@basistyp, ':'), if (@restriction=true()) then ' &lt;Einschränkung&gt;' else ' &lt;Erweiterung&gt;')"/>
        </xsl:when>
        <xsl:when test="union">
          <xsl:value-of select="'&lt;Union&gt;'"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <feld 
      name="{@name}" 
      default="{if (@defaultWert) then concat(' = ', @defaultWert) else ''}" 
      typ="{$typangabe}" 
      multiplizitaet="{(@multiplizitaet, 1)[1]}"
    />
    <!--<feld 
      name="{@name}" 
      default="{if (@defaultWert) then concat(' = ', @defaultWert) else ''}" 
      typ="{if (@basistyp) then concat(substring-after(@basistyp, ':'), if (@restriction=true()) then ' &lt;Einschränkung&gt;' else ' &lt;Erweiterung&gt;') else substring-after(@typ, ':')}" 
      multiplizitaet="{(@multiplizitaet, 1)[1]}"
    />-->
  </xsl:template>
  
   <xsl:template match="eigenschaft[@typ]" mode="lite:klassendiagramm-sammlung-class">
      <xsl:param name="tiefe" tunnel="yes" as="xs:integer"/>
      <xsl:variable name="typelement" select="lite:resolve(@typ, ., false())"/>
      <xsl:apply-templates select="$typelement" mode="lite:klassendiagramm-sammlung-class"/>
   </xsl:template>

   <xsl:template match="eigenschaft[@referenz] | eigenschaftengruppe[@referenz]"
      mode="lite:klassendiagramm-sammlung-class">
      <xsl:param name="tiefe" tunnel="yes" as="xs:integer"/>
      <xsl:variable name="referenzelement" select="lite:resolve(@referenz, ., true())"/>
      <xsl:apply-templates select="$referenzelement" mode="lite:klassendiagramm-sammlung-class"/>
   </xsl:template>

   <!-- ############## Templates zur Umsetzung der Elemente in PlantUML ############### -->

   <xsl:template match="*:klasse" mode="lite:klassendiagramm-plantuml">
      <xsl:value-of select="concat('&#x0A;class ', @alias, @name-oder-id, @stereotyp, ' {&#x0A;')"/>
      <!-- Eigenschaften, die als Feld der Klasse angezeigt werden sollen -->
      <xsl:for-each select="*:feld">
         <xsl:value-of
            select="concat(@name, ': ', @typ, ' [', @multiplizitaet, ']', @defaultwert, '&#x0A;')"/>
      </xsl:for-each>
      <xsl:text>}&#x0A;&#x0A;</xsl:text>
   </xsl:template>

   <xsl:template match="*:relation" mode="lite:klassendiagramm-plantuml">
      <xsl:choose>
         <xsl:when test="@basistyp">
           <!-- 
             Pfeil zum Basistyp soll an der Kopfzeile der Klasse ansetzen.
             Daher bei left to right direction -l-|>
             bei top to bottom direction -u-|>
           -->
            <xsl:value-of select="concat(@parent-name, ' -l-|> ', @basistyp, '&#x0A;')"/>
         </xsl:when>
         <xsl:otherwise>
            <!-- Darstellung: Benennung über Multiplizität -->
            <xsl:value-of
               select="concat(@parent-name, ' ', @modifier, '--&gt; &quot;', @child-name,'\n', @multiplizitaet, '&quot; ', @child-typ, '&#x0A;')"
            />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!-- ############## Ausgabehandling ############### -->

   <xsl:template name="lite:write-textfile-return-log">
      <xsl:param name="content" as="node()"/>
      <xsl:param name="local-path"/>
      <xsl:param name="method" required="no">text</xsl:param>
      <xsl:variable name="path" select="concat($result-directory, '/', $local-path)"/>
      <xsl:result-document href="{$path}" method="{$method}">
         <xsl:sequence select="$content"/>
      </xsl:result-document>
      <log:result-document>
         <xsl:value-of select="$path"/>
      </log:result-document>
   </xsl:template>
</xsl:stylesheet>
