<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="urn:xoev-de:kosit:xoev:classic:transformation_4.2.0" xmlns:xoev-profil="urn:xoev-de:kosit:xoev:classic:access-layer:xoev-profil_4.2.0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="3.0" xmlns:sch="http://purl.oclc.org/dsdl/schematron" exclude-result-prefixes="xsl xmi xgen xoev xoev uml xd">

    <xsl:variable name="xoev:message-trees" as="document-node(element(message-trees))">
        <xsl:document>
            <message-trees>
                <xsl:for-each select="$xoev:my-xmodel/(descendant::packagedElement, descendant::nestedClassifier)[xoev-profil:xsdMessage(.)]">
                    <xsl:sort select="xoev:global-element-name(.)"/>
                    <xsl:variable name="prefix" select="
                            (ancestor::packagedElement/xoev-profil:xsdSchema(.)/@prefix[. != ''], ancestor::packagedElement/xoev-profil:xsdXModel(.)/@prefix)[1]"/>
                    <node name="{concat($prefix,':',xoev:global-element-name(.))}" id="{@xmi:id}">
                        <xsl:variable name="node-type" select="xoev:dependencies-by-client(.)[xoev-profil:xsdGlobalElementType(.)]/uml:resolve-supplier(.)"/>
                        <xsl:variable name="all-types" select="$node-type, $node-type/xoev:allExtendedParents(.), xoev:allExtendedParents(.)"/>
                        <xsl:for-each select="$all-types">
                            <xsl:sort select="xoev:type-name(.)"/>
                            <type name="{xoev:type-name(.)}" id="{@xmi:id}"/>
                        </xsl:for-each>
                        <xsl:apply-templates select="(., $node-type)/(xoev:allElements(.), xoev:allAttributes(.))" mode="xoev:tree-node">
                            <xsl:sort select="
                                    if ((xoev-profil:xsdElement(.), xoev-profil:xsdAttribute(.))/@isRef) then
                                        uml:resolve-type(.)/xoev:global-element-name(.)
                                    else
                                        @name"/>
                            <xsl:with-param name="collected-type-ids" select="@xmi:id"/>
                        </xsl:apply-templates>
                    </node>
                </xsl:for-each>
            </message-trees>
        </xsl:document>
    </xsl:variable>
    <xsl:key name="xoev:message-nodes-by-id" match="node" use="@id"/>
    <xsl:function name="xoev:message-nodes-by-id" as="element(node)*">
        <xsl:param name="id" as="xs:string"/>
        <xsl:sequence select="key('xoev:message-nodes-by-id', $id, $xoev:message-trees)"/>
    </xsl:function>
    <xsl:key name="xoev:message-nodes-by-type-id" match="node" use="type/@id"/>
    <xsl:function name="xoev:message-nodes-by-type-id" as="element(node)*">
        <xsl:param name="id" as="xs:string"/>
        <xsl:sequence select="key('xoev:message-nodes-by-type-id', $id, $xoev:message-trees)"/>
    </xsl:function>

    <xsl:variable name="xoev:type-trees" as="document-node(element(type-trees))">
        <xsl:document>
            <type-trees>
                <xsl:for-each select="$uml:root-model/(descendant::packagedElement, descendant::nestedClassifier)[(xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.))]">
                    <xsl:sort select="xoev:type-name(.)"/>
                    <xsl:variable name="prefix" select="
                            (ancestor::packagedElement/xoev-profil:xsdSchema(.)/@prefix[. != ''], ancestor::packagedElement/xoev-profil:xsdXModel(.)/@prefix)[1]"/>
                    <node name="{concat($prefix,':',xoev:type-name(.))}" id="{@xmi:id}">
                        <xsl:apply-templates select="(xoev:allElements(.), xoev:allAttributes(.))" mode="xoev:tree-node">
                            <xsl:sort select="
                                    if ((xoev-profil:xsdElement(.), xoev-profil:xsdAttribute(.))/@isRef) then
                                        uml:resolve-type(.)/xoev:global-element-name(.)
                                    else
                                        @name"/>
                            <xsl:with-param name="collected-type-ids" select="@xmi:id"/>
                        </xsl:apply-templates>
                    </node>
                </xsl:for-each>
            </type-trees>
        </xsl:document>
    </xsl:variable>
    <xsl:key name="xoev:type-nodes-by-id" match="node" use="@id"/>
    <xsl:function name="xoev:type-nodes-by-id" as="element(node)*">
        <xsl:param name="id" as="xs:string"/>
        <xsl:sequence select="key('xoev:type-nodes-by-id', $id, $xoev:type-trees)"/>
    </xsl:function>
    <xsl:key name="xoev:type-nodes-by-type-id" match="node" use="type/@id"/>
    <xsl:function name="xoev:type-nodes-by-type-id" as="element(node)*">
        <xsl:param name="id" as="xs:string"/>
        <xsl:sequence select="key('xoev:type-nodes-by-type-id', $id, $xoev:type-trees)"/>
    </xsl:function>

    <xsl:template match="ownedAttribute" mode="xoev:tree-node">
        <xsl:param name="collected-type-ids" required="yes"/>
        <xsl:variable name="node" select="."/>
        <xsl:variable name="uml-type" select="uml:resolve-type(.)"/>
        <xsl:variable name="element-form" select="
                (xoev-profil:xsdElement(.)/@form[. != 'default'],
                ancestor::packagedElement/xoev-profil:xsdSchema(.)/@elementFormDefault[. != 'default'],
                ancestor::packagedElement/xoev-profil:xsdXModel(.)/@elementFormDefault)[1]"/>
        <xsl:variable name="name">
            <xsl:choose>
                <xsl:when test="xoev-profil:xsdAttribute(.)">
                    <xsl:value-of select="concat('@', @name)"/>
                </xsl:when>
                <xsl:when test="xoev-profil:xsdElement(.)/@isRef = 'true'">
                    <xsl:value-of select="xoev:qualified-type-name($uml-type, ., true())"/>
                </xsl:when>
                <xsl:when test="$element-form = 'qualified'">
                    <xsl:value-of select="concat(xoev:getPrefix(.), ':', @name)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@name"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <node name="{$name}" id="{@xmi:id}">
            <xsl:variable name="node-type" select="$uml-type, $uml-type/xoev:dependencies-by-client(.)[xoev-profil:xsdGlobalElementType(.)]/uml:resolve-supplier(.)"/>
            <xsl:for-each select="$node-type/(., xoev:allExtendedParents(.))">
                <xsl:sort select="
                        if ($node/(xoev-profil:xsdElement(.), xoev-profil:xsdAttribute(.))/@isRef and @xmi:id = $uml-type/@xmi:id) then
                            xoev:global-element-name(.)
                        else
                            xoev:type-name(.)"/>
                <type name="{if($node/(xoev-profil:xsdElement(.),xoev-profil:xsdAttribute(.))/@isRef and @xmi:id = $uml-type/@xmi:id) then xoev:global-element-name(.) else xoev:type-name(.)}" id="{@xmi:id}"/>
            </xsl:for-each>
            <xsl:if test="not($node-type/@xmi:id = $collected-type-ids)">
                <xsl:apply-templates select="$node-type/(xoev:allElements(.), xoev:allAttributes(.))" mode="xoev:tree-node">
                    <xsl:sort select="
                            if ((xoev-profil:xsdElement(.), xoev-profil:xsdAttribute(.))/@isRef) then
                                uml:resolve-type(.)/xoev:global-element-name(.)
                            else
                                @name"/>
                    <xsl:with-param name="collected-type-ids" select="$collected-type-ids, $node-type/@xmi:id"/>
                </xsl:apply-templates>
            </xsl:if>
        </node>
    </xsl:template>

    <xsl:variable name="xoev:rules-and-contexts" as="document-node(element(rules-and-contexts))">
        <xsl:document>
            <rules-and-contexts>
                <xsl:for-each select="$uml:root-model//packagedElement[xoev-profil:xsdXModel(.)]//(packagedElement, nestedClassifier)/ownedRule">
                    <xsl:sort select="@name"/>
                    <xsl:variable name="rule" select="."/>
                    <xsl:variable name="owner" select="parent::*"/>
                    <xsl:variable name="contexts" select="
                            $owner[xoev-profil:schRuleSet(.)]/xoev:dependencies-by-client(.)[xoev-profil:schContext(.)]/uml:resolve-supplier(.),
                            $owner[not(xoev-profil:schRuleSet(.))]"/>
                    <rule name="{@name}" id="{@xmi:id}">
                        <xsl:apply-templates select="$contexts" mode="xoev:rule-context">
                            <xsl:with-param name="rule" select="$rule"/>
                        </xsl:apply-templates>
                    </rule>
                </xsl:for-each>
            </rules-and-contexts>
        </xsl:document>
    </xsl:variable>

    <xsl:template match="ownedAttribute | packagedElement | nestedClassifier" mode="xoev:rule-context">
        <xsl:param name="rule" as="element()" required="yes"/>
        <xsl:variable name="context" select="."/>
        <xsl:variable name="constrained-element" select="($rule/uml:resolve-constrainedElement(.), $context)[1]"/>
        <context name="{$context/@name}" id="{$context/@xmi:id}" constrainedElementName="{$constrained-element/@name}" constrainedElementId="{$constrained-element/@xmi:id}">
            <xsl:variable name="context-in-message-trees" select="$context/(xoev:message-nodes-by-id(@xmi:id), xoev:message-nodes-by-type-id(@xmi:id))"/>
            <xsl:variable name="constrained-element-in-message-trees" select="$constrained-element/(xoev:message-nodes-by-id(@xmi:id), xoev:message-nodes-by-type-id(@xmi:id))"/>
            <xsl:variable name="paths-to-context">
                <paths-to-context>
                    <xsl:for-each select="$context-in-message-trees">
                        <path name-path="{xoev:name-path-from-context-to-root(.)}">
                            <xsl:value-of select="xoev:id-path-from-context-to-root(.)"/>
                        </path>
                    </xsl:for-each>
                </paths-to-context>
            </xsl:variable>
            <xsl:variable name="paths-from-context-to-constrained-element">
                <paths-from-context-to-constrained-element>
                    <xsl:choose>
                        <xsl:when test="$context[xoev-profil:xsdNamedType(.) or xoev-profil:xsdGlobalElementAndNamedType(.)]">
                            <xsl:variable name="context-in-type-trees" select="$xoev:type-trees/type-trees/node[@id = $context/@xmi:id]"/>
                            <xsl:variable name="constrained-element-in-type-trees" select="$constrained-element/(xoev:type-nodes-by-id(@xmi:id), xoev:type-nodes-by-type-id(@xmi:id))"/>
                            <xsl:for-each select="$constrained-element-in-type-trees">
                                <xsl:variable name="name-path" select="xoev:name-path-from-constrained-element-to-context(., $context-in-type-trees[1])"/>
                                <xsl:variable name="id-path" select="xoev:id-path-from-constrained-element-to-context(., $context-in-type-trees[1])"/>
                                <xsl:if test="not(starts-with($name-path, '#null#') or $name-path = '')">
                                    <path name-path="{$name-path}">
                                        <xsl:value-of select="$id-path"/>
                                    </path>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:for-each select="$constrained-element-in-message-trees">
                                <xsl:variable name="name-path" select="xoev:name-path-from-constrained-element-to-context(., $context-in-message-trees[1])"/>
                                <xsl:variable name="id-path" select="xoev:id-path-from-constrained-element-to-context(., $context-in-message-trees[1])"/>
                                <xsl:if test="not(starts-with($name-path, '#null#') or $name-path = '')">
                                    <path name-path="{$name-path}">
                                        <xsl:value-of select="$id-path"/>
                                    </path>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </paths-from-context-to-constrained-element>
            </xsl:variable>
            <xsl:sequence select="$paths-to-context"/>
            <xsl:sequence select="$paths-from-context-to-constrained-element"/>
            <full-paths>
                <xsl:for-each select="$paths-to-context//path">
                    <xsl:variable name="path-to-context" select="."/>
                    <xsl:choose>
                        <xsl:when test="empty($paths-from-context-to-constrained-element//path)">
                            <path>
                                <xsl:value-of select="xoev:compact-path($path-to-context, $constrained-element/@xmi:id, $context/@xmi:id)"/>
                            </path>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:for-each select="$paths-from-context-to-constrained-element//path">
                                <path>
                                    <xsl:value-of select="xoev:compact-path(concat($path-to-context, .), $constrained-element/@xmi:id, $context/@xmi:id)"/>
                                </path>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </full-paths>
        </context>
    </xsl:template>

    <xsl:function name="xoev:name-path-from-context-to-root" as="xs:string">
        <xsl:param name="node" as="element()"/>
        <xsl:choose>
            <xsl:when test="$node/parent::message-trees">
                <xsl:value-of select="$node/@name"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(xoev:name-path-from-context-to-root($node/parent::node), '/', $node/@name)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:id-path-from-context-to-root" as="xs:string">
        <xsl:param name="node" as="element()"/>
        <xsl:choose>
            <xsl:when test="$node/parent::message-trees">
                <xsl:value-of select="$node/@id"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(xoev:id-path-from-context-to-root($node/parent::node), '/', $node/@id)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:name-path-from-constrained-element-to-context" as="xs:string">
        <xsl:param name="node" as="element()"/>
        <xsl:param name="context" as="element()"/>
        <xsl:choose>
            <xsl:when test="empty($node/parent::*)">
                <xsl:text>#null#</xsl:text>
            </xsl:when>
            <xsl:when test="$node/@id = $context/@id">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(xoev:name-path-from-constrained-element-to-context($node/parent::*, $context), '/', $node/@name)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:id-path-from-constrained-element-to-context" as="xs:string">
        <xsl:param name="node" as="element()"/>
        <xsl:param name="context" as="element()"/>
        <xsl:choose>
            <xsl:when test="empty($node/parent::*)">
                <xsl:text>#null#</xsl:text>
            </xsl:when>
            <xsl:when test="$node/@id = $context/@id">
                <xsl:text/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(xoev:id-path-from-constrained-element-to-context($node/parent::*, $context), '/', $node/@id)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="xoev:compact-path" as="xs:string">
        <xsl:param name="full-path" as="xs:string"/>
        <xsl:param name="constrained-element-id" as="xs:string"/>
        <xsl:param name="context-id" as="xs:string"/>
        <xsl:value-of select="xoev:compact-path-step(tokenize($full-path, '/'), 1, $constrained-element-id, $context-id)"/>
    </xsl:function>

    <xsl:function name="xoev:compact-path-step" as="xs:string">
        <xsl:param name="full-path-tokenized" as="xs:string+"/>
        <xsl:param name="step" as="xs:integer"/>
        <xsl:param name="constrained-element-id" as="xs:string"/>
        <xsl:param name="context-id" as="xs:string"/>
        <xsl:variable name="step-id" select="$full-path-tokenized[$step]"/>
        <xsl:variable name="last-step-id" select="$full-path-tokenized[last()]"/>
        <xsl:variable name="step-name" select="xoev:message-nodes-by-id($step-id)[1]/@name"/>
        <xsl:variable name="last-step-name" select="xoev:message-nodes-by-id($last-step-id)[1]/@name"/>
        <xsl:choose>
            <xsl:when test="empty($full-path-tokenized[$step + 1])">
                <xsl:value-of select="$step-name"/>
            </xsl:when>
            <xsl:when test="
                    every $node in xoev:message-nodes-by-id($step-id)/descendant::node
                        satisfies
                        not($last-step-name = $node/@name) or
                        $node/(type/@id, @id) = $constrained-element-id and $node/ancestor-or-self::node[(type/@id, @id) = $context-id]">
                <xsl:value-of select="concat($step-name, '//', $last-step-name)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat($step-name, '/', xoev:compact-path-step($full-path-tokenized, $step + 1, $constrained-element-id, $context-id))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
